/*
 * Decompiled with CFR 0.152.
 */
package lajp;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import lajp.Buffer;
import lajp.MethodNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectUtil {
    private static Class<?> getClass(String clazzName) throws ClassNotFoundException {
        Class<?> clazz = Buffer.clazzMap.get(clazzName);
        if (clazz == null) {
            clazz = Class.forName(clazzName);
            Buffer.clazzMap.put(clazzName, clazz);
        }
        return clazz;
    }

    private static List<Method> getAllStaticPublicFinalMethods(String clazzName) throws ClassNotFoundException {
        Method[] methods;
        Class<?> clazz = ReflectUtil.getClass(clazzName);
        List<Method> retList = Buffer.methodMap.get(clazzName);
        if (retList != null) {
            return retList;
        }
        retList = new ArrayList<Method>();
        Method[] methodArray = methods = clazz.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            int m = method.getModifiers();
            if (Modifier.isPublic(m) && Modifier.isStatic(m) && Modifier.isFinal(m)) {
                retList.add(method);
            }
            ++n2;
        }
        Buffer.methodMap.put(clazzName, retList);
        return retList;
    }

    public static Method matchingMethod(String clazzName, String methodName, Class<?>[] argsClazz) throws ClassNotFoundException, MethodNotFoundException {
        Object sb3;
        StringBuilder sb2;
        List<Method> methodsInClass = ReflectUtil.getAllStaticPublicFinalMethods(clazzName);
        ArrayList<Method> sameNameMethods = new ArrayList<Method>();
        for (Method method : methodsInClass) {
            if (!method.getName().equals(methodName)) continue;
            sameNameMethods.add(method);
        }
        if (sameNameMethods.size() == 0) {
            throw new MethodNotFoundException("Can't match method: " + clazzName + "." + methodName + ", it must be [public] [static] [final].");
        }
        if (sameNameMethods.size() == 1) {
            Class<?>[] paramTypes = ((Method)sameNameMethods.get(0)).getParameterTypes();
            if (paramTypes.length != argsClazz.length) {
                sb2 = new StringBuilder();
                sb2.append(clazzName);
                sb2.append(".");
                sb2.append(methodName);
                sb2.append("(");
                sb2.append(argsClazz.length).append(" parameters");
                sb2.append(")");
                throw new MethodNotFoundException("Can't match method: " + sb2.toString());
            }
            boolean matchOK = true;
            int i = 0;
            while (i < argsClazz.length) {
                if (argsClazz[i] != null && !argsClazz[i].equals(paramTypes[i])) {
                    matchOK = false;
                    break;
                }
                ++i;
            }
            if (matchOK) {
                return (Method)sameNameMethods.get(0);
            }
            StringBuilder sb3 = new StringBuilder();
            sb3.append(clazzName);
            sb3.append(".");
            sb3.append(methodName);
            sb3.append("(");
            int i2 = 0;
            while (i2 < argsClazz.length) {
                sb3.append(argsClazz[i2] == null ? "null" : paramTypes[i2].getName());
                if (i2 != argsClazz.length - 1) {
                    sb3.append(",");
                }
                ++i2;
            }
            sb3.append(")");
            throw new MethodNotFoundException("Can't match method: " + sb3.toString());
        }
        ArrayList<Method> countMatch = new ArrayList<Method>();
        for (Method method : sameNameMethods) {
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes.length != argsClazz.length) continue;
            countMatch.add(method);
        }
        if (countMatch.size() == 0) {
            sb2 = new StringBuilder();
            sb2.append(clazzName);
            sb2.append(".");
            sb2.append(methodName);
            sb2.append("(");
            int i = 0;
            while (i < argsClazz.length) {
                sb2.append(argsClazz[i].getName());
                if (i != argsClazz.length - 1) {
                    sb2.append(",");
                }
                ++i;
            }
            sb2.append(")");
            throw new MethodNotFoundException("Can't match method: " + sb2.toString());
        }
        ArrayList<Method> allMatchMeshods = new ArrayList<Method>();
        for (Method method : countMatch) {
            boolean matchOK = true;
            int i = 0;
            while (i < argsClazz.length) {
                if (argsClazz[i] != null && !argsClazz[i].equals(method.getParameterTypes()[i])) {
                    matchOK = false;
                    break;
                }
                ++i;
            }
            if (!matchOK) continue;
            allMatchMeshods.add(method);
        }
        if (allMatchMeshods.size() == 0) {
            sb3 = new StringBuilder();
            ((StringBuilder)sb3).append(clazzName);
            ((StringBuilder)sb3).append(".");
            ((StringBuilder)sb3).append(methodName);
            ((StringBuilder)sb3).append("(");
            int i = 0;
            while (i < argsClazz.length) {
                ((StringBuilder)sb3).append(argsClazz[i].getName());
                if (i != argsClazz.length - 1) {
                    ((StringBuilder)sb3).append(",");
                }
                ++i;
            }
            ((StringBuilder)sb3).append(")");
            throw new MethodNotFoundException("Can't match method: " + ((StringBuilder)sb3).toString());
        }
        if (allMatchMeshods.size() == 1) {
            return (Method)allMatchMeshods.get(0);
        }
        sb3 = new StringBuilder();
        ((StringBuilder)sb3).append(clazzName);
        ((StringBuilder)sb3).append(".");
        ((StringBuilder)sb3).append(methodName);
        ((StringBuilder)sb3).append("(");
        ((StringBuilder)sb3).append(argsClazz.length).append(" parameters");
        ((StringBuilder)sb3).append(")");
        throw new MethodNotFoundException("More than one matching methods for " + ((StringBuilder)sb3).toString());
    }

    public static final String javaBean2Php(String clazzName) {
        BeanInfo beanInfo;
        Class<?> javaBean = null;
        try {
            javaBean = ReflectUtil.getClass(clazzName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return "Can't find JavaBean Class: " + clazzName;
        }
        try {
            beanInfo = Introspector.getBeanInfo(javaBean, Object.class);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            return "IntrospectionException for " + javaBean;
        }
        PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
        StringBuilder ret = new StringBuilder();
        ret.append("class ").append(clazzName.replace('.', '_')).append("<br>\n");
        ret.append("{").append("<br>\n");
        PropertyDescriptor[] propertyDescriptorArray = pds;
        int n = pds.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            ret.append("&nbsp;&nbsp;&nbsp;&nbsp;").append("var $").append(pd.getName()).append(";<br>\n");
            ++n2;
        }
        ret.append("}").append("<br>\n");
        return ret.toString();
    }
}

