/*
 * Decompiled with CFR 0.152.
 */
package lajp;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lajp.ArgsNode;
import lajp.MethodNotFoundException;
import lajp.MsgQ;
import lajp.PhpJava;
import lajp.ReflectUtil;

class SingleThread
extends Thread {
    static String PHP_CHARSET = "UTF-8";
    static final int REQUEST_MIN_LEN = 51;
    int processId;
    byte[] buffer = new byte[8192];
    byte[] args;
    int argsLen;
    int sp = 0;
    ArgsNode argsTree;
    String clazzName;
    String methodName;
    Class<?>[] argsClazz;
    Object[] argsValue;
    byte[] callBack = new byte[4096];
    int cbp = 0;
    byte[] response = new byte[8192];
    int rsp = 0;

    public SingleThread(int processId) {
        this.processId = processId;
    }

    public void run() {
        boolean runState = true;
        if (MsgQ.msgsnd(PhpJava.msqid, this.processId + 1, new byte[0], 0) != 0) {
            System.out.println("[LAJP Error(warn)]: HandShake send error.");
            return;
        }
        int bufLen = MsgQ.msgrcv(PhpJava.msqid, this.buffer, this.buffer.length, this.processId);
        if (bufLen < 51) {
            byte[] exMsg = this.exceptionRsp("request message length < REQUEST_MIN_LEN");
            MsgQ.msgsnd(PhpJava.msqid, this.processId + 1, exMsg, exMsg.length);
            return;
        }
        int a = 11;
        int b = this.nextIndex(this.buffer, (byte)59, a);
        int split_count = Integer.parseInt(new String(this.buffer, a, b - a));
        a = this.nextIndex(this.buffer, (byte)58, b + 1);
        a = this.nextIndex(this.buffer, (byte)58, a + 1) + 1;
        b = this.nextIndex(this.buffer, (byte)59, a);
        int split_seq = Integer.parseInt(new String(this.buffer, a, b - a));
        a = this.nextIndex(this.buffer, (byte)115, b + 1) + 2;
        b = this.nextIndex(this.buffer, (byte)58, a + 1);
        int split_msg_len = Integer.parseInt(new String(this.buffer, a, b - a));
        int split_msg_start = b + 2;
        this.args = new byte[split_count * 4096 + split_count * 128];
        System.arraycopy(this.buffer, split_msg_start, this.args, 0, split_msg_len);
        this.argsLen += split_msg_len;
        int i = 1;
        while (i < split_count) {
            bufLen = MsgQ.msgrcv(PhpJava.msqid, this.buffer, this.buffer.length, this.processId);
            if (bufLen < 51) {
                byte[] exMsg = this.exceptionRsp("request message length < REQUEST_MIN_LEN");
                MsgQ.msgsnd(PhpJava.msqid, this.processId + 1, exMsg, exMsg.length);
                return;
            }
            a = this.nextIndex(this.buffer, (byte)115, 0) + 2;
            b = this.nextIndex(this.buffer, (byte)58, a + 1);
            split_msg_len = Integer.parseInt(new String(this.buffer, a, b - a));
            split_msg_start = b + 2;
            System.arraycopy(this.buffer, split_msg_start, this.args, this.argsLen, split_msg_len);
            this.argsLen += split_msg_len;
            ++i;
        }
        a = this.nextIndex(this.args, (byte)58, 0) + 1;
        b = this.nextIndex(this.args, (byte)58, a);
        int argsCount = Integer.parseInt(new String(this.args, a, b - a));
        this.argsTree = ArgsNode.createNode("a", null, argsCount);
        this.sp = this.nextIndex(this.args, (byte)123, 0) + 1;
        try {
            this.parseArgs(this.argsTree);
        }
        catch (Exception e) {
            e.printStackTrace();
            byte[] exMsg = this.exceptionRsp("parse request message error: " + e.getMessage());
            MsgQ.msgsnd(PhpJava.msqid, this.processId + 1, exMsg, exMsg.length);
            return;
        }
        try {
            this.parseArgsTree();
        }
        catch (Exception e) {
            byte[] exMsg = this.exceptionRsp("parse request message error: " + e.getMessage());
            MsgQ.msgsnd(PhpJava.msqid, this.processId + 1, exMsg, exMsg.length);
            return;
        }
        Method method = null;
        try {
            method = ReflectUtil.matchingMethod(this.clazzName, this.methodName, this.argsClazz);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            byte[] exMsg = this.exceptionRsp("ClassNotFoundException: " + e.getMessage());
            MsgQ.msgsnd(PhpJava.msqid, this.processId + 1, exMsg, exMsg.length);
            return;
        }
        catch (MethodNotFoundException e) {
            e.printStackTrace();
            byte[] exMsg = this.exceptionRsp("MethodNotFoundException: " + e.getMessage());
            MsgQ.msgsnd(PhpJava.msqid, this.processId + 1, exMsg, exMsg.length);
            return;
        }
        Object obj = null;
        try {
            obj = method.invoke(null, this.argsValue);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            byte[] exMsg = this.exceptionRsp("IllegalArgumentException for call method " + this.clazzName + "." + method.getName());
            MsgQ.msgsnd(PhpJava.msqid, this.processId + 1, exMsg, exMsg.length);
            return;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            byte[] exMsg = this.exceptionRsp("IllegalAccessException for call method " + this.clazzName + "." + method.getName());
            MsgQ.msgsnd(PhpJava.msqid, this.processId + 1, exMsg, exMsg.length);
            return;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            byte[] exMsg = this.exceptionRsp("InvocationTargetException for call method " + this.clazzName + "." + method.getName());
            MsgQ.msgsnd(PhpJava.msqid, this.processId + 1, exMsg, exMsg.length);
            return;
        }
        if (obj == null) {
            byte[] voidResponse = this.voidResponse();
            MsgQ.msgsnd(PhpJava.msqid, this.processId + 1, voidResponse, voidResponse.length);
            return;
        }
        try {
            this.javaSeriallze2Php(null, obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            byte[] exMsg = this.exceptionRsp("Response message error: " + e.getMessage());
            MsgQ.msgsnd(PhpJava.msqid, this.processId + 1, exMsg, exMsg.length);
            return;
        }
        int splitCount = 0;
        int divisor = this.cbp / 4096;
        int remainder = this.cbp % 4096;
        splitCount = divisor < 1 ? 1 : (remainder != 0 ? divisor + 1 : divisor);
        int splitPoint = 0;
        int i2 = 0;
        while (i2 < splitCount) {
            a = splitPoint;
            b = a + 4096;
            splitPoint = b = b < this.cbp ? b : this.cbp;
            byte[] splitCountBytes = ("" + splitCount).getBytes();
            byte[] seqBytes = ("" + (i2 + 1)).getBytes();
            byte[] msgBytes = new byte[b - a];
            System.arraycopy(this.callBack, a, msgBytes, 0, msgBytes.length);
            byte[] msgLenBytes = ("" + msgBytes.length).getBytes();
            this.rsp = 0;
            this.response[this.rsp++] = 97;
            this.response[this.rsp++] = 58;
            this.response[this.rsp++] = 51;
            this.response[this.rsp++] = 58;
            this.response[this.rsp++] = 123;
            this.response[this.rsp++] = 105;
            this.response[this.rsp++] = 58;
            this.response[this.rsp++] = 48;
            this.response[this.rsp++] = 59;
            this.response[this.rsp++] = 105;
            this.response[this.rsp++] = 58;
            System.arraycopy(splitCountBytes, 0, this.response, this.rsp, splitCountBytes.length);
            this.rsp += splitCountBytes.length;
            this.response[this.rsp++] = 59;
            this.response[this.rsp++] = 105;
            this.response[this.rsp++] = 58;
            this.response[this.rsp++] = 49;
            this.response[this.rsp++] = 59;
            this.response[this.rsp++] = 105;
            this.response[this.rsp++] = 58;
            System.arraycopy(seqBytes, 0, this.response, this.rsp, seqBytes.length);
            this.rsp += seqBytes.length;
            this.response[this.rsp++] = 59;
            this.response[this.rsp++] = 105;
            this.response[this.rsp++] = 58;
            this.response[this.rsp++] = 50;
            this.response[this.rsp++] = 59;
            this.response[this.rsp++] = 115;
            this.response[this.rsp++] = 58;
            System.arraycopy(msgLenBytes, 0, this.response, this.rsp, msgLenBytes.length);
            this.rsp += msgLenBytes.length;
            this.response[this.rsp++] = 58;
            this.response[this.rsp++] = 34;
            System.arraycopy(msgBytes, 0, this.response, this.rsp, msgBytes.length);
            this.rsp += msgBytes.length;
            this.response[this.rsp++] = 34;
            this.response[this.rsp++] = 59;
            this.response[this.rsp++] = 125;
            MsgQ.msgsnd(PhpJava.msqid, this.processId + 1, this.response, this.rsp);
            ++i2;
        }
    }

    private void parseArgs(ArgsNode father) throws Exception {
        block16: {
            byte valueType;
            block13: while (true) {
                if (this.sp >= this.argsLen) {
                    return;
                }
                if (this.args[this.sp] == 125) {
                    ++this.sp;
                    break block16;
                }
                byte nameType = this.args[this.sp];
                String name = null;
                switch (nameType) {
                    case 105: {
                        int a = this.sp + 2;
                        this.sp = this.nextIndex(this.args, (byte)59, a);
                        ++this.sp;
                        break;
                    }
                    case 115: {
                        int a = this.sp + 2;
                        this.sp = this.nextIndex(this.args, (byte)58, a);
                        int len = Integer.parseInt(new String(this.args, a, this.sp - a, PHP_CHARSET));
                        a = this.sp + 2;
                        this.sp = a + len;
                        name = new String(this.args, a, this.sp - a, PHP_CHARSET);
                        this.sp += 2;
                        break;
                    }
                    default: {
                        throw new Exception("index[" + nameType + "] must be 'i' or 's'");
                    }
                }
                valueType = this.args[this.sp];
                switch (valueType) {
                    case 78: {
                        father.addChild(ArgsNode.createNode("N", name, null));
                        this.sp += 2;
                        continue block13;
                    }
                    case 105: {
                        int a = this.sp + 2;
                        this.sp = this.nextIndex(this.args, (byte)59, a);
                        father.addChild(ArgsNode.createNode("i", name, Integer.parseInt(new String(this.args, a, this.sp - a, PHP_CHARSET))));
                        ++this.sp;
                        continue block13;
                    }
                    case 100: {
                        int a = this.sp + 2;
                        this.sp = this.nextIndex(this.args, (byte)59, a);
                        father.addChild(ArgsNode.createNode("d", name, Double.parseDouble(new String(this.args, a, this.sp - a, PHP_CHARSET))));
                        ++this.sp;
                        continue block13;
                    }
                    case 98: {
                        int a = this.sp + 2;
                        father.addChild(ArgsNode.createNode("b", name, this.args[a] == 49));
                        this.sp = a + 2;
                        continue block13;
                    }
                    case 115: {
                        int a = this.sp + 2;
                        this.sp = this.nextIndex(this.args, (byte)58, a);
                        int len = Integer.parseInt(new String(this.args, a, this.sp - a, PHP_CHARSET));
                        a = this.sp + 2;
                        father.addChild(ArgsNode.createNode("s", name, new String(this.args, a, len, PHP_CHARSET)));
                        this.sp = a + len;
                        this.sp += 2;
                        continue block13;
                    }
                    case 97: {
                        int a = this.sp + 2;
                        this.sp = this.nextIndex(this.args, (byte)58, a);
                        int arrayLen = Integer.parseInt(new String(this.args, a, this.sp - a, PHP_CHARSET));
                        ArgsNode arrayNode = ArgsNode.createNode("a", name, arrayLen);
                        father.addChild(arrayNode);
                        this.sp += 2;
                        this.parseArgs(arrayNode);
                        continue block13;
                    }
                    case 79: {
                        int a = this.sp + 2;
                        this.sp = this.nextIndex(this.args, (byte)58, a);
                        int len = Integer.parseInt(new String(this.args, a, this.sp - a, PHP_CHARSET));
                        a = this.sp + 2;
                        ArgsNode objNode = ArgsNode.createNode("O", name, new String(this.args, a, len, PHP_CHARSET));
                        father.addChild(objNode);
                        a = a + len + 2;
                        this.sp = this.nextIndex(this.args, (byte)58, a);
                        this.sp += 2;
                        this.parseArgs(objNode);
                        continue block13;
                    }
                }
                break;
            }
            throw new Exception("index[" + valueType + "] must be 'i','d','b','s','a','O'.");
        }
    }

    private void parseArgsTree() throws Exception {
        String clazzMethod = (String)this.argsTree.subList.get((int)0).Value;
        int coloncolonIndex = clazzMethod.indexOf("::");
        this.clazzName = clazzMethod.substring(0, coloncolonIndex);
        this.methodName = clazzMethod.substring(coloncolonIndex + 2);
        this.argsClazz = new Class[this.argsTree.subList.size() - 1];
        this.argsValue = new Object[this.argsTree.subList.size() - 1];
        int i = 0;
        while (i < this.argsClazz.length) {
            ArgsNode currentNode = this.argsTree.subList.get(i + 1);
            String type = currentNode.type;
            if (type.equals("N")) {
                this.argsClazz[i] = null;
            } else if (type.equals("i")) {
                this.argsClazz[i] = Integer.TYPE;
            } else if (type.equals("d")) {
                this.argsClazz[i] = Double.TYPE;
            } else if (type.equals("b")) {
                this.argsClazz[i] = Boolean.TYPE;
            } else if (type.equals("s")) {
                this.argsClazz[i] = String.class;
            } else if (type.equals("a")) {
                String subNodeName;
                this.argsClazz[i] = currentNode.subList.size() > 0 ? ((subNodeName = currentNode.subList.get((int)0).name) == null ? List.class : Map.class) : List.class;
            } else if (type.equals("O")) {
                String phpClazzName = (String)currentNode.Value;
                String javaClazzName = phpClazzName.replace('_', '.');
                try {
                    this.argsClazz[i] = Class.forName(javaClazzName);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    throw new Exception("Can't find Class " + javaClazzName + " in Java.");
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.argsValue.length) {
            this.argsValue[i] = this.parseArgsNodeValue(this.argsTree.subList.get(i + 1));
            ++i;
        }
    }

    private Object parseArgsNodeValue(ArgsNode node) throws Exception {
        if (node.type.equals("N")) {
            return null;
        }
        if (node.type.equals("i")) {
            return (Integer)node.Value;
        }
        if (node.type.equals("d")) {
            return (Double)node.Value;
        }
        if (node.type.equals("b")) {
            return (Boolean)node.Value;
        }
        if (node.type.equals("s")) {
            return (String)node.Value;
        }
        if (node.type.equals("a")) {
            if (node.subList.size() > 0) {
                String subNodeName = node.subList.get((int)0).name;
                if (subNodeName == null) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (ArgsNode subNode : node.subList) {
                        list.add(this.parseArgsNodeValue(subNode));
                    }
                    return list;
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (ArgsNode subNode : node.subList) {
                    map.put(subNode.name, this.parseArgsNodeValue(subNode));
                }
                return map;
            }
            return new ArrayList();
        }
        if (node.type.equals("O")) {
            String phpClazzName = (String)node.Value;
            String javaClazzName = phpClazzName.replace('_', '.');
            try {
                Object retObj = Class.forName(javaClazzName).newInstance();
                if (node.subList.size() > 0) {
                    for (ArgsNode subNode : node.subList) {
                        if (subNode.type.equals("i") || subNode.type.equals("d") || subNode.type.equals("b") || subNode.type.equals("s")) {
                            this.javaBeanSetXXX(retObj, subNode.name, subNode.Value);
                            continue;
                        }
                        if (!subNode.type.equals("a") && !subNode.type.equals("O")) continue;
                        this.javaBeanSetXXX(retObj, subNode.name, this.parseArgsNodeValue(subNode));
                    }
                }
                return retObj;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                throw new Exception("Can't create instantiation of Class: " + javaClazzName);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new Exception("Illega access of Class: " + javaClazzName);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new Exception("Can't find class: " + javaClazzName);
            }
        }
        return null;
    }

    private void javaBeanSetXXX(Object javaBean, String attributeName, Object value) throws Exception {
        PropertyDescriptor[] pds;
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(javaBean.getClass(), Object.class);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            throw new Exception("IntrospectionException for " + javaBean.getClass());
        }
        PropertyDescriptor[] propertyDescriptorArray = pds = beanInfo.getPropertyDescriptors();
        int n = pds.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            if (pd.getName().equals(attributeName)) {
                try {
                    Method method = pd.getWriteMethod();
                    method.invoke(javaBean, value);
                    break;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    throw new Exception("IllegalArgumentException for " + javaBean.getClass() + "." + attributeName);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    throw new Exception("IllegalAccessException for " + javaBean.getClass() + "." + attributeName);
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    throw new Exception("InvocationTargetException for " + javaBean.getClass() + "." + attributeName);
                }
            }
            ++n2;
        }
    }

    private void javaSeriallze2Php(Object name, Object obj) throws Exception {
        String vv;
        if (name != null) {
            if (name instanceof Integer) {
                int index = (Integer)name;
                String nn = "i:" + index + ";";
                try {
                    this.copy2CallBack(nn.getBytes(PHP_CHARSET));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            } else if (name instanceof String) {
                String key = (String)name;
                byte[] key_b = null;
                try {
                    key_b = key.getBytes(PHP_CHARSET);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                StringBuilder nn = new StringBuilder();
                nn.append("s:");
                nn.append(key_b.length);
                nn.append(":\"");
                nn.append(key);
                nn.append("\";");
                try {
                    this.copy2CallBack(nn.toString().getBytes(PHP_CHARSET));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        if (obj == null) {
            byte[] nullValue = new byte[]{78, 59};
            this.copy2CallBack(nullValue);
        } else if (obj instanceof Integer) {
            int i = (Integer)obj;
            vv = "i:" + i + ";";
            try {
                this.copy2CallBack(vv.getBytes(PHP_CHARSET));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        } else if (obj instanceof Double) {
            double d = (Double)obj;
            String vv2 = "d:" + d + ";";
            try {
                this.copy2CallBack(vv2.getBytes(PHP_CHARSET));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        } else if (obj instanceof Boolean) {
            boolean b = (Boolean)obj;
            vv = "b:" + (b ? "1" : "0") + ";";
            try {
                this.copy2CallBack(vv.getBytes(PHP_CHARSET));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        } else if (obj instanceof String) {
            String s = (String)obj;
            try {
                byte[] sByte = null;
                sByte = s == null ? new byte[]{} : s.getBytes(PHP_CHARSET);
                byte[] sByteLen = ("" + sByte.length).getBytes(PHP_CHARSET);
                byte[] vv3 = new byte[2 + sByteLen.length + 2 + sByte.length + 2];
                vv3[0] = 115;
                vv3[1] = 58;
                System.arraycopy(sByteLen, 0, vv3, 2, sByteLen.length);
                vv3[2 + sByteLen.length] = 58;
                vv3[2 + sByteLen.length + 1] = 34;
                System.arraycopy(sByte, 0, vv3, 2 + sByteLen.length + 2, sByte.length);
                vv3[2 + sByteLen.length + 2 + sByte.length] = 34;
                vv3[2 + sByteLen.length + 2 + sByte.length + 1] = 59;
                this.copy2CallBack(vv3);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        } else if (obj instanceof List) {
            List list = (List)obj;
            byte[] arrayLen = null;
            try {
                arrayLen = ("" + list.size()).getBytes(PHP_CHARSET);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            byte[] vv1 = new byte[2 + arrayLen.length + 2];
            vv1[0] = 97;
            vv1[1] = 58;
            System.arraycopy(arrayLen, 0, vv1, 2, arrayLen.length);
            vv1[2 + arrayLen.length] = 58;
            vv1[2 + arrayLen.length + 1] = 123;
            this.copy2CallBack(vv1);
            int i = 0;
            while (i < list.size()) {
                Object subObj = list.get(i);
                this.javaSeriallze2Php(i, subObj);
                ++i;
            }
            byte[] vv2 = new byte[]{125};
            this.copy2CallBack(vv2);
        } else if (obj instanceof Map) {
            Map map = (Map)obj;
            Set keySet = map.keySet();
            byte[] arrayLen = null;
            try {
                arrayLen = ("" + keySet.size()).getBytes(PHP_CHARSET);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            byte[] vv1 = new byte[2 + arrayLen.length + 2];
            vv1[0] = 97;
            vv1[1] = 58;
            System.arraycopy(arrayLen, 0, vv1, 2, arrayLen.length);
            vv1[2 + arrayLen.length] = 58;
            vv1[2 + arrayLen.length + 1] = 123;
            this.copy2CallBack(vv1);
            for (String key : keySet) {
                this.javaSeriallze2Php(key, map.get(key));
            }
            byte[] vv2 = new byte[]{125};
            this.copy2CallBack(vv2);
        } else {
            Class<?> clazz = obj.getClass();
            byte[] className_b = null;
            try {
                className_b = clazz.getName().getBytes(PHP_CHARSET);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            PropertyDescriptor[] pd = null;
            try {
                BeanInfo benaInfo = Introspector.getBeanInfo(clazz, Object.class);
                pd = benaInfo.getPropertyDescriptors();
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
                throw new Exception("IntrospectionException for class " + clazz.getName());
            }
            StringBuilder oo1 = new StringBuilder();
            oo1.append("O:");
            oo1.append(className_b.length);
            oo1.append(":\"");
            oo1.append(clazz.getName().replace('.', '_'));
            oo1.append("\":");
            oo1.append(pd.length);
            oo1.append(":{");
            try {
                this.copy2CallBack(oo1.toString().getBytes(PHP_CHARSET));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            int i = 0;
            while (i < pd.length) {
                try {
                    this.javaSeriallze2Php(pd[i].getName(), pd[i].getReadMethod().invoke(obj, null));
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    throw new Exception("IllegalArgumentException for attribute " + pd[i].getName() + " from class " + clazz.getName());
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    throw new Exception("IllegalAccessException for attribute " + pd[i].getName() + " from class " + clazz.getName());
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    throw new Exception("InvocationTargetException for attribute " + pd[i].getName() + " from class " + clazz.getName());
                }
                ++i;
            }
            byte[] oo2 = new byte[]{125};
            this.copy2CallBack(oo2);
        }
    }

    private void copy2CallBack(byte[] cc) {
        while (cc.length + this.cbp > this.callBack.length) {
            byte[] newCallBack = new byte[this.callBack.length * 2];
            System.arraycopy(this.callBack, 0, newCallBack, 0, this.cbp);
            this.callBack = newCallBack;
        }
        System.arraycopy(cc, 0, this.callBack, this.cbp, cc.length);
        this.cbp += cc.length;
    }

    private int nextIndex(byte[] buf, byte c, int start) {
        int index = start;
        while (index < buf.length) {
            if (buf[index] == c) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private byte[] exceptionRsp(String exMsg) {
        byte[] ex = null;
        try {
            ex = exMsg.getBytes(PHP_CHARSET);
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        byte[] exLen = null;
        try {
            exLen = ("" + ex.length).getBytes(PHP_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        byte[] exBytes = new byte[2 + exLen.length + 2 + ex.length + 2];
        exBytes[0] = 115;
        exBytes[1] = 58;
        System.arraycopy(exLen, 0, exBytes, 2, exLen.length);
        exBytes[2 + exLen.length] = 58;
        exBytes[3 + exLen.length] = 34;
        System.arraycopy(ex, 0, exBytes, 3 + exLen.length + 1, ex.length);
        exBytes[4 + exLen.length + ex.length] = 34;
        exBytes[5 + exLen.length + ex.length] = 59;
        byte[] ret = new byte[26 + exBytes.length];
        ret[0] = 97;
        ret[1] = 58;
        ret[2] = 51;
        ret[3] = 58;
        ret[4] = 123;
        ret[5] = 105;
        ret[6] = 58;
        ret[7] = 48;
        ret[8] = 59;
        ret[9] = 105;
        ret[10] = 58;
        ret[11] = 48;
        ret[12] = 59;
        ret[13] = 105;
        ret[14] = 58;
        ret[15] = 49;
        ret[16] = 59;
        ret[17] = 105;
        ret[18] = 58;
        ret[19] = 49;
        ret[20] = 59;
        ret[21] = 105;
        ret[22] = 58;
        ret[23] = 50;
        ret[24] = 59;
        System.arraycopy(exBytes, 0, ret, 25, exBytes.length);
        ret[ret.length - 1] = 125;
        return ret;
    }

    private byte[] voidResponse() {
        byte[] ret = new byte[]{97, 58, 51, 58, 123, 105, 58, 48, 59, 105, 58, 49, 59, 105, 58, 49, 59, 105, 58, 49, 59, 105, 58, 50, 59, 78, 59, 125};
        return ret;
    }

    private void testArgsTree(ArgsNode node, int tab) {
        String tabCount = "";
        int i = 0;
        while (i < tab) {
            tabCount = String.valueOf(tabCount) + "\t";
            ++i;
        }
        if (node.type.equals("a") || node.type.equals("O")) {
            for (ArgsNode subNode : node.subList) {
                this.testArgsTree(subNode, tab + 1);
            }
        }
    }
}

