/*
 * Decompiled with CFR 0.152.
 */
package lajpsocket;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import lajpsocket.MethodNotFoundException;
import lajpsocket.ReflectUtil;
import lajpsocket.SingleThread;

public class PhpJava {
    static int port = 21230;
    ServerSocket serverSocket;

    public PhpJava() {
        PhpJava.setListenPort();
        try {
            this.serverSocket = new ServerSocket(port);
            System.out.println("Listen port: " + port);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        PhpJava.charset();
        PhpJava.autoRun();
        System.out.println("Server startup...");
        while (true) {
            try {
                while (true) {
                    Socket socket = this.serverSocket.accept();
                    new SingleThread(socket).start();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        System.out.println("-------------------------------------------");
        System.out.println("- LAJP-JAVA (Socket) Service");
        System.out.println("- Time: " + new Date());
        System.out.println("-------------------------------------------");
        new PhpJava();
    }

    private static void setListenPort() {
        String s_port = System.getenv("SERVICE_PORT");
        if (s_port != null && !s_port.trim().equals("")) {
            try {
                port = Integer.parseInt(s_port);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }
    }

    private static void charset() {
        String charset = System.getenv("CHARSET");
        if (charset != null && !charset.trim().equals("")) {
            try {
                "\u4e2d\u6587".getBytes(SingleThread.PHP_CHARSET);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                System.exit(-1);
            }
            System.out.println("set charser: " + charset);
            SingleThread.PHP_CHARSET = charset;
        } else {
            System.out.println("set charser: UTF-8");
        }
    }

    public static void autoRun() {
        String autoRunClassName = System.getenv("AUTORUN_CLASS");
        String autoRunMethodName = System.getenv("AUTORUN_METHOD");
        if (autoRunClassName != null && !autoRunClassName.trim().equals("") && autoRunMethodName != null && !autoRunMethodName.trim().equals("")) {
            Method method = null;
            try {
                method = ReflectUtil.matchingMethod(autoRunClassName, autoRunMethodName, new Class[0]);
            }
            catch (ClassNotFoundException e) {
                System.err.println("Can't find Class: " + autoRunClassName);
                e.printStackTrace();
                System.exit(-1);
            }
            catch (MethodNotFoundException e) {
                System.err.println("Can't find method: " + autoRunMethodName);
                e.printStackTrace();
                System.exit(-1);
            }
            try {
                method.invoke(null, null);
            }
            catch (IllegalArgumentException e) {
                System.err.println("IllegalArgumentException for call method " + autoRunClassName + "." + method.getName());
                e.printStackTrace();
                System.exit(-1);
            }
            catch (IllegalAccessException e) {
                System.err.println("IllegalAccessException for call method " + autoRunClassName + "." + method.getName());
                e.printStackTrace();
                System.exit(-1);
            }
            catch (InvocationTargetException e) {
                System.err.println("InvocationTargetException for call method " + autoRunClassName + "." + method.getName());
                e.printStackTrace();
                System.exit(-1);
            }
        }
    }
}

