/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.asn1;

import com.sansec.asn1.ASN1EncodableVector;
import com.sansec.asn1.ASN1Object;
import com.sansec.asn1.ASN1OutputStream;
import com.sansec.asn1.ASN1Sequence;
import com.sansec.asn1.ASN1SetParser;
import com.sansec.asn1.ASN1TaggedObject;
import com.sansec.asn1.DEREncodable;
import com.sansec.asn1.DERObject;
import com.sansec.asn1.DEROutputStream;
import com.sansec.asn1.DERSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public abstract class ASN1Set
extends ASN1Object {
    protected Vector set = new Vector();

    public static ASN1Set getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1Set) {
            return (ASN1Set)obj;
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1Set getInstance(ASN1TaggedObject obj, boolean explicit) {
        if (explicit) {
            if (!obj.isExplicit()) {
                throw new IllegalArgumentException("object implicit - explicit expected.");
            }
            return (ASN1Set)obj.getObject();
        }
        if (obj.isExplicit()) {
            DERSet set = new DERSet(obj.getObject());
            return set;
        }
        if (obj.getObject() instanceof ASN1Set) {
            return (ASN1Set)obj.getObject();
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (obj.getObject() instanceof ASN1Sequence) {
            ASN1Sequence s = (ASN1Sequence)obj.getObject();
            Enumeration e = s.getObjects();
            while (e.hasMoreElements()) {
                v.add((DEREncodable)e.nextElement());
            }
            return new DERSet(v, false);
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    public Enumeration getObjects() {
        return this.set.elements();
    }

    public DEREncodable getObjectAt(int index) {
        return (DEREncodable)this.set.elementAt(index);
    }

    public int size() {
        return this.set.size();
    }

    public ASN1SetParser parser() {
        final ASN1Set outer = this;
        return new ASN1SetParser(){
            private final int max;
            private int index;
            {
                this.max = ASN1Set.this.size();
            }

            public DEREncodable readObject() throws IOException {
                DEREncodable obj;
                if (this.index == this.max) {
                    return null;
                }
                if ((obj = ASN1Set.this.getObjectAt(this.index++)) instanceof ASN1Sequence) {
                    return ((ASN1Sequence)obj).parser();
                }
                if (obj instanceof ASN1Set) {
                    return ((ASN1Set)obj).parser();
                }
                return obj;
            }

            public DERObject getDERObject() {
                return outer;
            }
        };
    }

    public int hashCode() {
        Enumeration e = this.getObjects();
        int hashCode = this.size();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            hashCode *= 17;
            if (o == null) continue;
            hashCode ^= o.hashCode();
        }
        return hashCode;
    }

    boolean asn1Equals(DERObject o) {
        if (!(o instanceof ASN1Set)) {
            return false;
        }
        ASN1Set other = (ASN1Set)o;
        if (this.size() != other.size()) {
            return false;
        }
        Enumeration s1 = this.getObjects();
        Enumeration s2 = other.getObjects();
        while (s1.hasMoreElements()) {
            DERObject o2;
            DERObject o1 = ((DEREncodable)s1.nextElement()).getDERObject();
            if (o1 == (o2 = ((DEREncodable)s2.nextElement()).getDERObject()) || o1 != null && o1.equals(o2)) continue;
            return false;
        }
        return true;
    }

    private boolean lessThanOrEqual(byte[] a, byte[] b) {
        if (a.length <= b.length) {
            int i = 0;
            while (i != a.length) {
                int r = b[i] & 0xFF;
                int l = a[i] & 0xFF;
                if (r > l) {
                    return true;
                }
                if (l > r) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        int i = 0;
        while (i != b.length) {
            int r = b[i] & 0xFF;
            int l = a[i] & 0xFF;
            if (r > l) {
                return true;
            }
            if (l > r) {
                return false;
            }
            ++i;
        }
        return false;
    }

    private byte[] getEncoded(DEREncodable obj) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        try {
            aOut.writeObject(obj);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("cannot encode object added to SET");
        }
        return bOut.toByteArray();
    }

    protected void sort() {
        if (this.set.size() > 1) {
            boolean swapped = true;
            int lastSwap = this.set.size() - 1;
            while (swapped) {
                int index = 0;
                int swapIndex = 0;
                byte[] a = this.getEncoded((DEREncodable)this.set.elementAt(0));
                swapped = false;
                while (index != lastSwap) {
                    byte[] b = this.getEncoded((DEREncodable)this.set.elementAt(index + 1));
                    if (this.lessThanOrEqual(a, b)) {
                        a = b;
                    } else {
                        Object o = this.set.elementAt(index);
                        this.set.setElementAt(this.set.elementAt(index + 1), index);
                        this.set.setElementAt(o, index + 1);
                        swapped = true;
                        swapIndex = index;
                    }
                    ++index;
                }
                lastSwap = swapIndex;
            }
        }
    }

    protected void addObject(DEREncodable obj) {
        this.set.addElement(obj);
    }

    abstract void encode(DEROutputStream var1) throws IOException;

    public String toString() {
        return this.set.toString();
    }
}

