/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.asn1;

import com.sansec.asn1.ASN1OctetStringParser;
import com.sansec.asn1.ASN1StreamParser;
import java.io.IOException;
import java.io.InputStream;

class ConstructedOctetStream
extends InputStream {
    private final ASN1StreamParser _parser;
    private boolean _first = true;
    private InputStream _currentStream;

    ConstructedOctetStream(ASN1StreamParser parser) {
        this._parser = parser;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this._currentStream == null) {
            if (!this._first) {
                return -1;
            }
            ASN1OctetStringParser s = (ASN1OctetStringParser)this._parser.readObject();
            if (s == null) {
                return -1;
            }
            this._first = false;
            this._currentStream = s.getOctetStream();
        }
        int totalRead = 0;
        while (true) {
            int numRead;
            if ((numRead = this._currentStream.read(b, off + totalRead, len - totalRead)) >= 0) {
                if ((totalRead += numRead) != len) continue;
                return totalRead;
            }
            ASN1OctetStringParser aos = (ASN1OctetStringParser)this._parser.readObject();
            if (aos == null) {
                this._currentStream = null;
                return totalRead < 1 ? -1 : totalRead;
            }
            this._currentStream = aos.getOctetStream();
        }
    }

    public int read() throws IOException {
        if (this._currentStream == null) {
            if (!this._first) {
                return -1;
            }
            ASN1OctetStringParser s = (ASN1OctetStringParser)this._parser.readObject();
            if (s == null) {
                return -1;
            }
            this._first = false;
            this._currentStream = s.getOctetStream();
        }
        int b;
        while ((b = this._currentStream.read()) < 0) {
            ASN1OctetStringParser s = (ASN1OctetStringParser)this._parser.readObject();
            if (s == null) {
                this._currentStream = null;
                return -1;
            }
            this._currentStream = s.getOctetStream();
        }
        return b;
    }
}

