/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.asn1;

import com.sansec.asn1.ASN1Object;
import com.sansec.asn1.ASN1OctetString;
import com.sansec.asn1.ASN1TaggedObject;
import com.sansec.asn1.DERObject;
import com.sansec.asn1.DEROutputStream;
import com.sansec.util.Arrays;
import java.io.IOException;
import java.math.BigInteger;

public class DERInteger
extends ASN1Object {
    byte[] bytes;

    public static DERInteger getInstance(Object obj) {
        if (obj == null || obj instanceof DERInteger) {
            return (DERInteger)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new DERInteger(((ASN1OctetString)obj).getOctets());
        }
        if (obj instanceof ASN1TaggedObject) {
            return DERInteger.getInstance(((ASN1TaggedObject)obj).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERInteger getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DERInteger.getInstance(obj.getObject());
    }

    public DERInteger(int value) {
        this.bytes = BigInteger.valueOf(value).toByteArray();
    }

    public DERInteger(BigInteger value) {
        this.bytes = value.toByteArray();
    }

    public DERInteger(byte[] bytes) {
        this.bytes = bytes;
    }

    public BigInteger getValue() {
        return new BigInteger(this.bytes);
    }

    public BigInteger getPositiveValue() {
        return new BigInteger(1, this.bytes);
    }

    void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(2, this.bytes);
    }

    public int hashCode() {
        int value = 0;
        int i = 0;
        while (i != this.bytes.length) {
            value ^= (this.bytes[i] & 0xFF) << i % 4;
            ++i;
        }
        return value;
    }

    boolean asn1Equals(DERObject o) {
        if (!(o instanceof DERInteger)) {
            return false;
        }
        DERInteger other = (DERInteger)o;
        return Arrays.areEqual(this.bytes, other.bytes);
    }

    public String toString() {
        return this.getValue().toString();
    }
}

