/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.asn1;

import com.sansec.asn1.ASN1TaggedObject;
import com.sansec.asn1.DEREncodable;
import com.sansec.asn1.DEROutputStream;
import com.sansec.asn1.DERSequence;
import java.io.IOException;

public class DERTaggedObject
extends ASN1TaggedObject {
    private static final byte[] ZERO_BYTES = new byte[0];

    public DERTaggedObject(int tagNo, DEREncodable obj) {
        super(tagNo, obj);
    }

    public DERTaggedObject(boolean explicit, int tagNo, DEREncodable obj) {
        super(explicit, tagNo, obj);
    }

    public DERTaggedObject(int tagNo) {
        super(false, tagNo, new DERSequence());
    }

    void encode(DEROutputStream out) throws IOException {
        if (!this.empty) {
            byte[] bytes = this.obj.getDERObject().getEncoded("DER");
            if (this.explicit) {
                out.writeEncoded(160, this.tagNo, bytes);
            } else {
                int flags = (bytes[0] & 0x20) != 0 ? 160 : 128;
                out.writeTag(flags, this.tagNo);
                out.write(bytes, 1, bytes.length - 1);
            }
        } else {
            out.writeEncoded(160, this.tagNo, ZERO_BYTES);
        }
    }
}

