/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.asn1;

import com.sansec.asn1.DEREncodable;
import com.sansec.asn1.DEROutputStream;
import com.sansec.asn1.DERSequence;
import com.sansec.asn1.LazyDERConstructionEnumeration;
import java.io.IOException;
import java.util.Enumeration;

public class LazyDERSequence
extends DERSequence {
    private byte[] encoded;
    private boolean parsed = false;
    private int size = -1;

    LazyDERSequence(byte[] encoded) throws IOException {
        this.encoded = encoded;
    }

    private void parse() {
        LazyDERConstructionEnumeration en = new LazyDERConstructionEnumeration(this.encoded);
        while (en.hasMoreElements()) {
            this.addObject((DEREncodable)en.nextElement());
        }
        this.parsed = true;
    }

    public DEREncodable getObjectAt(int index) {
        if (!this.parsed) {
            this.parse();
        }
        return super.getObjectAt(index);
    }

    public Enumeration getObjects() {
        if (this.parsed) {
            return super.getObjects();
        }
        return new LazyDERConstructionEnumeration(this.encoded);
    }

    public int size() {
        if (this.size < 0) {
            LazyDERConstructionEnumeration en = new LazyDERConstructionEnumeration(this.encoded);
            this.size = 0;
            while (en.hasMoreElements()) {
                en.nextElement();
                ++this.size;
            }
        }
        return this.size;
    }

    void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(48, this.encoded);
    }
}

