/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.asn1.cmp;

import com.sansec.asn1.ASN1Encodable;
import com.sansec.asn1.ASN1EncodableVector;
import com.sansec.asn1.ASN1Sequence;
import com.sansec.asn1.DERObject;
import com.sansec.asn1.DERObjectIdentifier;
import com.sansec.asn1.DERSequence;

public class InfoTypeAndValue
extends ASN1Encodable {
    private DERObjectIdentifier infoType;
    private ASN1Encodable infoValue;

    private InfoTypeAndValue(ASN1Sequence seq) {
        this.infoType = DERObjectIdentifier.getInstance(seq.getObjectAt(0));
        if (seq.size() > 1) {
            this.infoValue = (ASN1Encodable)seq.getObjectAt(1);
        }
    }

    public static InfoTypeAndValue getInstance(Object o) {
        if (o instanceof InfoTypeAndValue) {
            return (InfoTypeAndValue)o;
        }
        if (o instanceof ASN1Sequence) {
            return new InfoTypeAndValue((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
    }

    public DERObjectIdentifier getInfoType() {
        return this.infoType;
    }

    public ASN1Encodable getInfoValue() {
        return this.infoValue;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.infoType);
        if (this.infoValue != null) {
            v.add(this.infoValue);
        }
        return new DERSequence(v);
    }
}

