/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.asn1.crmf;

import com.sansec.asn1.ASN1Encodable;
import com.sansec.asn1.ASN1EncodableVector;
import com.sansec.asn1.ASN1Sequence;
import com.sansec.asn1.DERObject;
import com.sansec.asn1.DERSequence;
import com.sansec.asn1.x509.SubjectPublicKeyInfo;

public class POPOSigningKeyInput
extends ASN1Encodable {
    private ASN1Encodable authInfo;
    private SubjectPublicKeyInfo publicKey;

    private POPOSigningKeyInput(ASN1Sequence seq) {
        this.authInfo = (ASN1Encodable)seq.getObjectAt(0);
        this.publicKey = SubjectPublicKeyInfo.getInstance(seq.getObjectAt(1));
    }

    public static POPOSigningKeyInput getInstance(Object o) {
        if (o instanceof POPOSigningKeyInput) {
            return (POPOSigningKeyInput)o;
        }
        if (o instanceof ASN1Sequence) {
            return new POPOSigningKeyInput((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
    }

    public SubjectPublicKeyInfo getPublicKey() {
        return this.publicKey;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.authInfo);
        v.add(this.publicKey);
        return new DERSequence(v);
    }
}

