/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.asn1.crmf;

import com.sansec.asn1.ASN1Choice;
import com.sansec.asn1.ASN1Encodable;
import com.sansec.asn1.ASN1TaggedObject;
import com.sansec.asn1.DERNull;
import com.sansec.asn1.DERObject;
import com.sansec.asn1.DERTaggedObject;
import com.sansec.asn1.crmf.POPOPrivKey;
import com.sansec.asn1.crmf.POPOSigningKey;

public class ProofOfPossession
extends ASN1Encodable
implements ASN1Choice {
    private int tagNo;
    private ASN1Encodable obj;

    private ProofOfPossession(ASN1TaggedObject tagged) {
        this.tagNo = tagged.getTagNo();
        switch (this.tagNo) {
            case 0: {
                this.obj = DERNull.INSTANCE;
                break;
            }
            case 1: {
                this.obj = POPOSigningKey.getInstance(tagged, false);
                break;
            }
            case 2: 
            case 3: {
                this.obj = POPOPrivKey.getInstance(tagged, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown tag: " + this.tagNo);
            }
        }
    }

    public static ProofOfPossession getInstance(Object o) {
        if (o instanceof ProofOfPossession) {
            return (ProofOfPossession)o;
        }
        if (o instanceof ASN1TaggedObject) {
            return new ProofOfPossession((ASN1TaggedObject)o);
        }
        throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
    }

    public int getType() {
        return this.tagNo;
    }

    public ASN1Encodable getObject() {
        return this.obj;
    }

    public DERObject toASN1Object() {
        return new DERTaggedObject(false, this.tagNo, this.obj);
    }
}

