/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.asn1.pkcs;

import com.sansec.asn1.ASN1Encodable;
import com.sansec.asn1.ASN1EncodableVector;
import com.sansec.asn1.ASN1Sequence;
import com.sansec.asn1.BERSequence;
import com.sansec.asn1.BERTaggedObject;
import com.sansec.asn1.DEREncodable;
import com.sansec.asn1.DERObject;
import com.sansec.asn1.DERObjectIdentifier;
import com.sansec.asn1.DERTaggedObject;
import com.sansec.asn1.pkcs.PKCSObjectIdentifiers;
import java.util.Enumeration;

public class ContentInfo
extends ASN1Encodable
implements PKCSObjectIdentifiers {
    private DERObjectIdentifier contentType;
    private DEREncodable content;

    public static ContentInfo getInstance(Object obj) {
        if (obj instanceof ContentInfo) {
            return (ContentInfo)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new ContentInfo((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory: " + obj.getClass().getName());
    }

    public ContentInfo(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.contentType = (DERObjectIdentifier)e.nextElement();
        if (e.hasMoreElements()) {
            this.content = ((DERTaggedObject)e.nextElement()).getObject();
        }
    }

    public ContentInfo(DERObjectIdentifier contentType, DEREncodable content) {
        this.contentType = contentType;
        this.content = content;
    }

    public DERObjectIdentifier getContentType() {
        return this.contentType;
    }

    public DEREncodable getContent() {
        return this.content;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.contentType);
        if (this.content != null) {
            v.add(new BERTaggedObject(0, this.content));
        }
        return new BERSequence(v);
    }
}

