/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.asn1.pkcs;

import com.sansec.asn1.ASN1Encodable;
import com.sansec.asn1.ASN1EncodableVector;
import com.sansec.asn1.ASN1Sequence;
import com.sansec.asn1.ASN1TaggedObject;
import com.sansec.asn1.DERInteger;
import com.sansec.asn1.DERObject;
import com.sansec.asn1.DEROctetString;
import com.sansec.asn1.DERSequence;
import java.math.BigInteger;
import java.util.Enumeration;

public class SM2CipherStructure
extends ASN1Encodable {
    private BigInteger x;
    private BigInteger y;
    private byte[] C;
    private byte[] M;

    public static SM2CipherStructure getInstance(ASN1TaggedObject obj, boolean explicit) {
        return SM2CipherStructure.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static SM2CipherStructure getInstance(Object obj) {
        if (obj instanceof SM2CipherStructure) {
            return (SM2CipherStructure)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new SM2CipherStructure((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory: " + obj.getClass().getName());
    }

    public SM2CipherStructure(int cLength, BigInteger x, BigInteger y, byte[] C, byte[] M) {
        this.x = x;
        this.y = y;
        this.C = C;
        this.M = M;
    }

    public SM2CipherStructure(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.x = ((DERInteger)e.nextElement()).getValue();
        this.y = ((DERInteger)e.nextElement()).getValue();
        this.M = ((DEROctetString)e.nextElement()).getOctets();
        this.C = ((DEROctetString)e.nextElement()).getOctets();
    }

    public BigInteger getX() {
        return this.x;
    }

    public BigInteger getY() {
        return this.y;
    }

    public byte[] getC() {
        return this.C;
    }

    public byte[] getM() {
        return this.M;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new DERInteger(this.getX()));
        v.add(new DERInteger(this.getY()));
        v.add(new DEROctetString(this.getM()));
        v.add(new DEROctetString(this.getC()));
        return new DERSequence(v);
    }
}

