/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.asn1.pkcs;

import com.sansec.asn1.ASN1Encodable;
import com.sansec.asn1.ASN1EncodableVector;
import com.sansec.asn1.ASN1Object;
import com.sansec.asn1.ASN1OctetString;
import com.sansec.asn1.ASN1Sequence;
import com.sansec.asn1.ASN1TaggedObject;
import com.sansec.asn1.DERBitString;
import com.sansec.asn1.DEREncodable;
import com.sansec.asn1.DERInteger;
import com.sansec.asn1.DERObject;
import com.sansec.asn1.DEROctetString;
import com.sansec.asn1.DERSequence;
import com.sansec.asn1.DERTaggedObject;
import com.sansec.util.BigIntegers;
import java.math.BigInteger;
import java.util.Enumeration;

public class SM2PrivateKeyStructure
extends ASN1Encodable {
    private ASN1Sequence seq;

    public SM2PrivateKeyStructure(ASN1Sequence seq) {
        this.seq = seq;
    }

    public SM2PrivateKeyStructure(BigInteger key) {
        byte[] bytes = BigIntegers.asUnsignedByteArray(key);
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new DERInteger(1));
        v.add(new DEROctetString(bytes));
        this.seq = new DERSequence(v);
    }

    public SM2PrivateKeyStructure(BigInteger key, ASN1Encodable parameters) {
        this(key, null, parameters);
    }

    public SM2PrivateKeyStructure(BigInteger key, DERBitString publicKey, ASN1Encodable parameters) {
        byte[] bytes = BigIntegers.asUnsignedByteArray(key);
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new DERInteger(1));
        v.add(new DEROctetString(bytes));
        if (parameters != null) {
            v.add(new DERTaggedObject(true, 0, parameters));
        }
        if (publicKey != null) {
            v.add(new DERTaggedObject(true, 1, publicKey));
        }
        this.seq = new DERSequence(v);
    }

    public BigInteger getKey() {
        ASN1OctetString octs = (ASN1OctetString)this.seq.getObjectAt(1);
        return new BigInteger(1, octs.getOctets());
    }

    public DERBitString getPublicKey() {
        return (DERBitString)this.getObjectInTag(1);
    }

    public ASN1Object getParameters() {
        return this.getObjectInTag(0);
    }

    private ASN1Object getObjectInTag(int tagNo) {
        Enumeration e = this.seq.getObjects();
        while (e.hasMoreElements()) {
            ASN1TaggedObject tag;
            DEREncodable obj = (DEREncodable)e.nextElement();
            if (!(obj instanceof ASN1TaggedObject) || (tag = (ASN1TaggedObject)obj).getTagNo() != tagNo) continue;
            return (ASN1Object)tag.getObject().getDERObject();
        }
        return null;
    }

    public DERObject toASN1Object() {
        return this.seq;
    }
}

