/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.asn1.pkcs;

import com.sansec.asn1.ASN1Encodable;
import com.sansec.asn1.ASN1EncodableVector;
import com.sansec.asn1.ASN1Sequence;
import com.sansec.asn1.ASN1TaggedObject;
import com.sansec.asn1.DERInteger;
import com.sansec.asn1.DERObject;
import com.sansec.asn1.DERSequence;
import java.math.BigInteger;
import java.util.Enumeration;

public class SM2SignStructure
extends ASN1Encodable {
    private BigInteger r;
    private BigInteger s;

    public static SM2SignStructure getInstance(ASN1TaggedObject obj, boolean explicit) {
        return SM2SignStructure.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static SM2SignStructure getInstance(Object obj) {
        if (obj instanceof SM2SignStructure) {
            return (SM2SignStructure)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new SM2SignStructure((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory: " + obj.getClass().getName());
    }

    public SM2SignStructure(BigInteger r, BigInteger s) {
        this.r = r;
        this.s = s;
    }

    public SM2SignStructure(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.r = ((DERInteger)e.nextElement()).getValue();
        this.s = ((DERInteger)e.nextElement()).getValue();
    }

    public BigInteger getR() {
        return this.r;
    }

    public BigInteger getS() {
        return this.s;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new DERInteger(this.getR()));
        v.add(new DERInteger(this.getS()));
        return new DERSequence(v);
    }
}

