/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.asn1.pkcs;

import com.sansec.asn1.pkcs.SM2Cipher;
import com.sansec.asn1.pkcs.SM2CipherStructure;
import com.sansec.asn1.pkcs.SM2SignStructure;
import com.sansec.device.bean.SM2refCipher;
import com.sansec.device.bean.SM2refSignature;
import com.sansec.util.BigIntegerUitl;
import java.math.BigInteger;

public class SM2StructureUtil {
    public static SM2CipherStructure convert(SM2refCipher cipher) {
        int cLength = cipher.getCLength();
        BigInteger x = BigIntegerUitl.toPositiveInteger(cipher.getX());
        BigInteger y = BigIntegerUitl.toPositiveInteger(cipher.getY());
        byte[] C = new byte[cLength];
        System.arraycopy(cipher.getC(), 0, C, 0, C.length);
        byte[] M = cipher.getM();
        SM2CipherStructure cipherSt = new SM2CipherStructure(cLength, x, y, C, M);
        return cipherSt;
    }

    public static SM2refCipher convert(SM2CipherStructure cipherSt) {
        byte[] x = BigIntegerUitl.asUnsigned32ByteArray(cipherSt.getX());
        byte[] y = BigIntegerUitl.asUnsigned32ByteArray(cipherSt.getY());
        byte[] C = cipherSt.getC();
        byte[] M = cipherSt.getM();
        SM2refCipher cipher = new SM2refCipher(x, y, C, M);
        return cipher;
    }

    public static SM2Cipher convertExt(SM2refCipher cipher) {
        byte[] x = cipher.getX();
        byte[] y = cipher.getY();
        byte[] C = new byte[32];
        System.arraycopy(cipher.getC(), 0, C, 0, C.length);
        byte[] M = cipher.getM();
        SM2Cipher cipherSt = new SM2Cipher(x, y, C, M);
        return cipherSt;
    }

    public static SM2refCipher convert(SM2Cipher cipherSt) {
        byte[] x = cipherSt.getX();
        byte[] y = cipherSt.getY();
        byte[] C = cipherSt.getC();
        byte[] M = cipherSt.getM();
        SM2refCipher cipher = new SM2refCipher(x, y, C, M);
        return cipher;
    }

    public static SM2SignStructure convert(SM2refSignature signature) {
        BigInteger r = BigIntegerUitl.toPositiveInteger(signature.getR());
        BigInteger s = BigIntegerUitl.toPositiveInteger(signature.getS());
        SM2SignStructure signatureSt = new SM2SignStructure(r, s);
        return signatureSt;
    }

    public static SM2refSignature convert(SM2SignStructure signatureSt) {
        byte[] r = BigIntegerUitl.asUnsigned32ByteArray(signatureSt.getR());
        byte[] s = BigIntegerUitl.asUnsigned32ByteArray(signatureSt.getS());
        SM2refSignature signature = new SM2refSignature(r, s);
        return signature;
    }
}

