/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.asn1.x509.qualified;

import com.sansec.asn1.ASN1Encodable;
import com.sansec.asn1.ASN1EncodableVector;
import com.sansec.asn1.ASN1Sequence;
import com.sansec.asn1.DERObject;
import com.sansec.asn1.DERObjectIdentifier;
import com.sansec.asn1.DERSequence;
import com.sansec.asn1.x509.GeneralName;
import java.util.Enumeration;

public class SemanticsInformation
extends ASN1Encodable {
    DERObjectIdentifier semanticsIdentifier;
    GeneralName[] nameRegistrationAuthorities;

    public static SemanticsInformation getInstance(Object obj) {
        if (obj == null || obj instanceof SemanticsInformation) {
            return (SemanticsInformation)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new SemanticsInformation(ASN1Sequence.getInstance(obj));
        }
        throw new IllegalArgumentException("unknown object in getInstance");
    }

    public SemanticsInformation(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        if (seq.size() < 1) {
            throw new IllegalArgumentException("no objects in SemanticsInformation");
        }
        Object object = e.nextElement();
        if (object instanceof DERObjectIdentifier) {
            this.semanticsIdentifier = DERObjectIdentifier.getInstance(object);
            object = e.hasMoreElements() ? e.nextElement() : null;
        }
        if (object != null) {
            ASN1Sequence generalNameSeq = ASN1Sequence.getInstance(object);
            this.nameRegistrationAuthorities = new GeneralName[generalNameSeq.size()];
            int i = 0;
            while (i < generalNameSeq.size()) {
                this.nameRegistrationAuthorities[i] = GeneralName.getInstance(generalNameSeq.getObjectAt(i));
                ++i;
            }
        }
    }

    public SemanticsInformation(DERObjectIdentifier semanticsIdentifier, GeneralName[] generalNames) {
        this.semanticsIdentifier = semanticsIdentifier;
        this.nameRegistrationAuthorities = generalNames;
    }

    public SemanticsInformation(DERObjectIdentifier semanticsIdentifier) {
        this.semanticsIdentifier = semanticsIdentifier;
        this.nameRegistrationAuthorities = null;
    }

    public SemanticsInformation(GeneralName[] generalNames) {
        this.semanticsIdentifier = null;
        this.nameRegistrationAuthorities = generalNames;
    }

    public DERObjectIdentifier getSemanticsIdentifier() {
        return this.semanticsIdentifier;
    }

    public GeneralName[] getNameRegistrationAuthorities() {
        return this.nameRegistrationAuthorities;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector seq = new ASN1EncodableVector();
        if (this.semanticsIdentifier != null) {
            seq.add(this.semanticsIdentifier);
        }
        if (this.nameRegistrationAuthorities != null) {
            ASN1EncodableVector seqname = new ASN1EncodableVector();
            int i = 0;
            while (i < this.nameRegistrationAuthorities.length) {
                seqname.add(this.nameRegistrationAuthorities[i]);
                ++i;
            }
            seq.add(new DERSequence(seqname));
        }
        return new DERSequence(seq);
    }
}

