/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.asn1.x9;

import com.sansec.asn1.ASN1Encodable;
import com.sansec.asn1.ASN1OctetString;
import com.sansec.asn1.DERObject;
import com.sansec.asn1.DEROctetString;
import com.sansec.asn1.x9.X9IntegerConverter;
import com.sansec.math.ec.ECFieldElement;
import java.math.BigInteger;

public class X9FieldElement
extends ASN1Encodable {
    protected ECFieldElement f;
    private static X9IntegerConverter converter = new X9IntegerConverter();

    public X9FieldElement(ECFieldElement f) {
        this.f = f;
    }

    public X9FieldElement(BigInteger p, ASN1OctetString s) {
        this(new ECFieldElement.Fp(p, new BigInteger(1, s.getOctets())));
    }

    public X9FieldElement(int m, int k1, int k2, int k3, ASN1OctetString s) {
        this(new ECFieldElement.F2m(m, k1, k2, k3, new BigInteger(1, s.getOctets())));
    }

    public ECFieldElement getValue() {
        return this.f;
    }

    public DERObject toASN1Object() {
        int byteCount = converter.getByteLength(this.f);
        byte[] paddedBigInteger = converter.integerToBytes(this.f.toBigInteger(), byteCount);
        return new DEROctetString(paddedBigInteger);
    }
}

