/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.digests;

import com.sansec.util.ByteUtil;
import com.sansec.util.ConvertUtil;
import java.math.BigInteger;

class SM31 {
    public static final byte[] iv = new BigInteger("7380166f4914b2b9172442d7da8a0600a96f30bc163138aae38dee4db0fb0e4e", 16).toByteArray();
    public static int[] Tj = new int[64];

    static {
        int i = 0;
        while (i < 16) {
            SM31.Tj[i] = 2043430169;
            ++i;
        }
        i = 16;
        while (i < 64) {
            SM31.Tj[i] = 2055708042;
            ++i;
        }
    }

    SM31() {
    }

    public static byte[] CF(byte[] V, byte[] B) {
        int[] v = SM31.convert(V);
        int[] b = SM31.convert(B);
        return SM31.convert(SM31.CF(v, b));
    }

    private static int[] convert(byte[] arr) {
        int[] out = new int[arr.length / 4];
        byte[] tmp = new byte[4];
        int i = 0;
        while (i < arr.length) {
            System.arraycopy(arr, i, tmp, 0, 4);
            out[i / 4] = SM31.bigEndianByteToInt(tmp);
            i += 4;
        }
        return out;
    }

    private static byte[] convert(int[] arr) {
        byte[] out = new byte[arr.length * 4];
        byte[] tmp = null;
        int i = 0;
        while (i < arr.length) {
            tmp = SM31.bigEndianIntToByte(arr[i]);
            System.arraycopy(tmp, 0, out, i * 4, 4);
            ++i;
        }
        return out;
    }

    public static int[] CF(int[] V, int[] B) {
        int a = V[0];
        int b = V[1];
        int c = V[2];
        int d = V[3];
        int e = V[4];
        int f = V[5];
        int g = V[6];
        int h = V[7];
        int[][] arr = SM31.expand(B);
        int[] w = arr[0];
        int[] w1 = arr[1];
        int j = 0;
        while (j < 64) {
            int ss1 = SM31.bitCycleLeft(a, 12) + e + SM31.bitCycleLeft(Tj[j], j);
            ss1 = SM31.bitCycleLeft(ss1, 7);
            int ss2 = ss1 ^ SM31.bitCycleLeft(a, 12);
            int tt1 = SM31.FFj(a, b, c, j) + d + ss2 + w1[j];
            int tt2 = SM31.GGj(e, f, g, j) + h + ss1 + w[j];
            d = c;
            c = SM31.bitCycleLeft(b, 9);
            b = a;
            a = tt1;
            h = g;
            g = SM31.bitCycleLeft(f, 19);
            f = e;
            e = SM31.P0(tt2);
            ++j;
        }
        int[] out = new int[]{a ^ V[0], b ^ V[1], c ^ V[2], d ^ V[3], e ^ V[4], f ^ V[5], g ^ V[6], h ^ V[7]};
        return out;
    }

    private static int[][] expand(byte[] B) {
        int[] W = new int[68];
        int[] W1 = new int[64];
        byte[] tmp = new byte[4];
        int i = 0;
        while (i < B.length) {
            int j = 0;
            while (j < 4) {
                tmp[j] = B[i + j];
                ++j;
            }
            W[i / 4] = SM31.bigEndianByteToInt(tmp);
            i += 4;
        }
        i = 16;
        while (i < 68) {
            W[i] = SM31.P1(W[i - 16] ^ W[i - 9] ^ SM31.bitCycleLeft(W[i - 3], 15)) ^ SM31.bitCycleLeft(W[i - 13], 7) ^ W[i - 6];
            ++i;
        }
        i = 0;
        while (i < 64) {
            W1[i] = W[i] ^ W[i + 4];
            ++i;
        }
        int[][] arr = new int[][]{W, W1};
        return arr;
    }

    private static int[][] expand(int[] B) {
        return SM31.expand(SM31.convert(B));
    }

    private static byte[] bigEndianIntToByte(int num) {
        return SM31.back(ConvertUtil.IntToByte(num));
    }

    private static int bigEndianByteToInt(byte[] bytes) {
        return ConvertUtil.ByteToInt(SM31.back(bytes));
    }

    private static int FFj(int X, int Y, int Z, int j) {
        if (j >= 0 && j <= 15) {
            return SM31.FF1j(X, Y, Z);
        }
        return SM31.FF2j(X, Y, Z);
    }

    private static int GGj(int X, int Y, int Z, int j) {
        if (j >= 0 && j <= 15) {
            return SM31.GG1j(X, Y, Z);
        }
        return SM31.GG2j(X, Y, Z);
    }

    private static int FF1j(int X, int Y, int Z) {
        int tmp = X ^ Y ^ Z;
        return tmp;
    }

    private static int FF2j(int X, int Y, int Z) {
        int tmp = X & Y | X & Z | Y & Z;
        return tmp;
    }

    private static int GG1j(int X, int Y, int Z) {
        int tmp = X ^ Y ^ Z;
        return tmp;
    }

    private static int GG2j(int X, int Y, int Z) {
        int tmp = X & Y | ~X & Z;
        return tmp;
    }

    private static int P0(int X) {
        int t = X ^ SM31.bitCycleLeft(X, 9) ^ SM31.bitCycleLeft(X, 17);
        return t;
    }

    private static int P1(int X) {
        int t = X ^ SM31.bitCycleLeft(X, 15) ^ SM31.bitCycleLeft(X, 23);
        return t;
    }

    public static byte[] padding(byte[] in, int bLen) {
        int k = 448 - (8 * in.length + 1) % 512;
        if (k < 0) {
            k = 960 - (8 * in.length + 1) % 512;
        }
        byte[] padd = new byte[++k / 8];
        padd[0] = -128;
        long n = in.length * 8 + bLen * 512;
        byte[] out = new byte[in.length + k / 8 + 8];
        int pos = 0;
        System.arraycopy(in, 0, out, 0, in.length);
        System.arraycopy(padd, 0, out, pos += in.length, padd.length);
        byte[] tmp = SM31.back(ByteUtil.LongToByte(n));
        System.arraycopy(tmp, 0, out, pos += padd.length, tmp.length);
        return out;
    }

    private static byte[] back(byte[] in) {
        byte[] out = new byte[in.length];
        int i = 0;
        while (i < out.length) {
            out[i] = in[out.length - i - 1];
            ++i;
        }
        return out;
    }

    private static int bitCycleLeft(int n, int bitLen) {
        byte[] tmp = SM31.bigEndianIntToByte(n);
        int byteLen = (bitLen %= 32) / 8;
        int len = bitLen % 8;
        if (byteLen > 0) {
            tmp = SM31.byteCycleLeft(tmp, byteLen);
        }
        if (len > 0) {
            tmp = SM31.bitSmall8CycleLeft(tmp, len);
        }
        return SM31.bigEndianByteToInt(tmp);
    }

    private static byte[] bitSmall8CycleLeft(byte[] in, int len) {
        byte[] tmp = new byte[in.length];
        int i = 0;
        while (i < tmp.length) {
            byte t1 = (byte)((in[i] & 0xFF) << len);
            byte t2 = (byte)((in[(i + 1) % tmp.length] & 0xFF) >> 8 - len);
            byte t3 = (byte)(t1 | t2);
            tmp[i] = t3;
            ++i;
        }
        return tmp;
    }

    private static byte[] byteCycleLeft(byte[] in, int byteLen) {
        byte[] tmp = new byte[in.length];
        System.arraycopy(in, byteLen, tmp, 0, in.length - byteLen);
        System.arraycopy(in, 0, tmp, in.length - byteLen, byteLen);
        return tmp;
    }

    public static void print(int[] arr) {
        int i = 0;
        while (i < arr.length) {
            System.out.print(String.valueOf(Integer.toHexString(arr[i])) + " ");
            if ((i + 1) % 8 == 0) {
                System.out.println();
            }
            ++i;
        }
        System.out.println();
    }
}

