/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.digests;

import com.sansec.crypto.Digest;
import com.sansec.crypto.digests.SM31;
import com.sansec.crypto.digests.SM3Digest;
import com.sansec.crypto.params.SM2PublicKeyParameters;
import com.sansec.device.bean.GlobalData;
import com.sansec.device.bean.SM2refPublicKey;
import com.sansec.util.BigIntegerUitl;
import com.sansec.util.ConvertUtil;
import java.math.BigInteger;

public class SM3Digest1
implements Digest {
    private static final int BYTE_LENGTH = 32;
    private static final int BLOCK_LENGTH = 64;
    private static final int BUFFER_LENGTH = 128;
    private byte[] xBuf = new byte[128];
    private int xBufOff;
    private byte[] V = SM31.iv;
    private int cntBlock = 0;

    public int doFinal(byte[] out, int outOff) {
        byte[] tmp = this.doFinal();
        System.arraycopy(tmp, 0, out, 0, tmp.length);
        return 32;
    }

    public String getAlgorithmName() {
        return "SM3";
    }

    public int getDigestSize() {
        return 32;
    }

    public void reset() {
        this.xBufOff = 0;
        this.cntBlock = 0;
        this.V = SM31.iv;
    }

    public void update(byte in) {
        this.xBuf[this.xBufOff++] = in;
        if (this.xBufOff == 128) {
            this.doUpdate();
            this.xBufOff = 0;
        }
    }

    public void update(byte[] in, int inOff, int len) {
        if (this.xBufOff + len > 128) {
            int tmpLen = this.xBufOff + len - 128;
            System.arraycopy(in, inOff, this.xBuf, this.xBufOff, 128 - this.xBufOff);
            this.doUpdate();
            this.xBufOff = 0;
            while (tmpLen > 128) {
                tmpLen -= 128;
                System.arraycopy(in, inOff, this.xBuf, this.xBufOff, 128 - this.xBufOff);
                this.doUpdate();
                this.xBufOff = 0;
            }
            System.arraycopy(in, inOff + len - tmpLen, this.xBuf, this.xBufOff, tmpLen);
            this.xBufOff += tmpLen;
        } else if (this.xBufOff + len == 128) {
            System.arraycopy(in, inOff, this.xBuf, this.xBufOff, len);
            this.doUpdate();
            this.xBufOff = 0;
        } else {
            System.arraycopy(in, inOff, this.xBuf, this.xBufOff, len);
            this.xBufOff += len;
        }
    }

    private void doUpdate() {
        byte[] B = new byte[64];
        int i = 0;
        while (i < 128) {
            System.arraycopy(this.xBuf, i, B, 0, B.length);
            this.doHash(B);
            i += 64;
        }
        this.cntBlock += 2;
    }

    private void doHash(byte[] B) {
        this.V = SM31.CF(this.V, B);
    }

    private byte[] doFinal() {
        byte[] B = new byte[64];
        byte[] buffer = new byte[this.xBufOff];
        System.arraycopy(this.xBuf, 0, buffer, 0, buffer.length);
        byte[] tmp = SM31.padding(buffer, this.cntBlock);
        int i = 0;
        while (i < tmp.length) {
            System.arraycopy(tmp, i, B, 0, B.length);
            this.doHash(B);
            ++this.cntBlock;
            i += 64;
        }
        return this.V;
    }

    private byte[] getSM2Za(SM2refPublicKey publicKey, byte[] id) {
        byte[] tmp = ConvertUtil.IntToByte(id.length * 8);
        byte[] buffer = new byte[194 + id.length];
        buffer[0] = tmp[1];
        buffer[1] = tmp[0];
        byte[] a = GlobalData.a.toByteArray();
        byte[] b = GlobalData.b.toByteArray();
        byte[] gx = GlobalData.Gx.toByteArray();
        byte[] gy = GlobalData.Gy.toByteArray();
        byte[] x = publicKey.getX();
        byte[] y = publicKey.getY();
        int dPos = 2;
        System.arraycopy(id, 0, buffer, dPos, id.length);
        System.arraycopy(a, 0, buffer, dPos += id.length, 32);
        System.arraycopy(b, 0, buffer, dPos += 32, 32);
        System.arraycopy(gx, 0, buffer, dPos += 32, 32);
        System.arraycopy(gy, 0, buffer, dPos += 32, 32);
        System.arraycopy(x, 0, buffer, dPos += 32, 32);
        System.arraycopy(y, 0, buffer, dPos += 32, 32);
        dPos += 32;
        SM3Digest digest = new SM3Digest();
        digest.update(buffer, 0, buffer.length);
        byte[] out = new byte[32];
        digest.doFinal(out, 0);
        return out;
    }

    public void addId(SM2PublicKeyParameters paramKey, byte[] id) {
        this.addId(paramKey.getX(), paramKey.getY(), id);
    }

    public void addId(BigInteger affineX, BigInteger affineY, byte[] id) {
        byte[] x = BigIntegerUitl.asUnsigned32ByteArray(affineX);
        byte[] y = BigIntegerUitl.asUnsigned32ByteArray(affineY);
        SM2refPublicKey publicKey = new SM2refPublicKey(x, y);
        byte[] tmp = this.getSM2Za(publicKey, id);
        this.reset();
        System.arraycopy(tmp, 0, this.xBuf, this.xBufOff, 32);
        this.xBufOff = 32;
    }
}

