/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.digests;

import com.sansec.crypto.ExtendedDigest;
import com.sansec.util.Arrays;

public final class WhirlpoolDigest
implements ExtendedDigest {
    private static final int BYTE_LENGTH = 64;
    private static final int DIGEST_LENGTH_BYTES = 64;
    private static final int ROUNDS = 10;
    private static final int REDUCTION_POLYNOMIAL = 285;
    private static final int[] SBOX;
    private static final long[] C0;
    private static final long[] C1;
    private static final long[] C2;
    private static final long[] C3;
    private static final long[] C4;
    private static final long[] C5;
    private static final long[] C6;
    private static final long[] C7;
    private final long[] _rc = new long[11];
    private static final int BITCOUNT_ARRAY_SIZE = 32;
    private byte[] _buffer = new byte[64];
    private int _bufferPos = 0;
    private short[] _bitCount = new short[32];
    private long[] _hash = new long[8];
    private long[] _K = new long[8];
    private long[] _L = new long[8];
    private long[] _block = new long[8];
    private long[] _state = new long[8];
    private static final short[] EIGHT;

    static {
        int[] nArray = new int[256];
        nArray[0] = 24;
        nArray[1] = 35;
        nArray[2] = 198;
        nArray[3] = 232;
        nArray[4] = 135;
        nArray[5] = 184;
        nArray[6] = 1;
        nArray[7] = 79;
        nArray[8] = 54;
        nArray[9] = 166;
        nArray[10] = 210;
        nArray[11] = 245;
        nArray[12] = 121;
        nArray[13] = 111;
        nArray[14] = 145;
        nArray[15] = 82;
        nArray[16] = 96;
        nArray[17] = 188;
        nArray[18] = 155;
        nArray[19] = 142;
        nArray[20] = 163;
        nArray[21] = 12;
        nArray[22] = 123;
        nArray[23] = 53;
        nArray[24] = 29;
        nArray[25] = 224;
        nArray[26] = 215;
        nArray[27] = 194;
        nArray[28] = 46;
        nArray[29] = 75;
        nArray[30] = 254;
        nArray[31] = 87;
        nArray[32] = 21;
        nArray[33] = 119;
        nArray[34] = 55;
        nArray[35] = 229;
        nArray[36] = 159;
        nArray[37] = 240;
        nArray[38] = 74;
        nArray[39] = 218;
        nArray[40] = 88;
        nArray[41] = 201;
        nArray[42] = 41;
        nArray[43] = 10;
        nArray[44] = 177;
        nArray[45] = 160;
        nArray[46] = 107;
        nArray[47] = 133;
        nArray[48] = 189;
        nArray[49] = 93;
        nArray[50] = 16;
        nArray[51] = 244;
        nArray[52] = 203;
        nArray[53] = 62;
        nArray[54] = 5;
        nArray[55] = 103;
        nArray[56] = 228;
        nArray[57] = 39;
        nArray[58] = 65;
        nArray[59] = 139;
        nArray[60] = 167;
        nArray[61] = 125;
        nArray[62] = 149;
        nArray[63] = 216;
        nArray[64] = 251;
        nArray[65] = 238;
        nArray[66] = 124;
        nArray[67] = 102;
        nArray[68] = 221;
        nArray[69] = 23;
        nArray[70] = 71;
        nArray[71] = 158;
        nArray[72] = 202;
        nArray[73] = 45;
        nArray[74] = 191;
        nArray[75] = 7;
        nArray[76] = 173;
        nArray[77] = 90;
        nArray[78] = 131;
        nArray[79] = 51;
        nArray[80] = 99;
        nArray[81] = 2;
        nArray[82] = 170;
        nArray[83] = 113;
        nArray[84] = 200;
        nArray[85] = 25;
        nArray[86] = 73;
        nArray[87] = 217;
        nArray[88] = 242;
        nArray[89] = 227;
        nArray[90] = 91;
        nArray[91] = 136;
        nArray[92] = 154;
        nArray[93] = 38;
        nArray[94] = 50;
        nArray[95] = 176;
        nArray[96] = 233;
        nArray[97] = 15;
        nArray[98] = 213;
        nArray[99] = 128;
        nArray[100] = 190;
        nArray[101] = 205;
        nArray[102] = 52;
        nArray[103] = 72;
        nArray[104] = 255;
        nArray[105] = 122;
        nArray[106] = 144;
        nArray[107] = 95;
        nArray[108] = 32;
        nArray[109] = 104;
        nArray[110] = 26;
        nArray[111] = 174;
        nArray[112] = 180;
        nArray[113] = 84;
        nArray[114] = 147;
        nArray[115] = 34;
        nArray[116] = 100;
        nArray[117] = 241;
        nArray[118] = 115;
        nArray[119] = 18;
        nArray[120] = 64;
        nArray[121] = 8;
        nArray[122] = 195;
        nArray[123] = 236;
        nArray[124] = 219;
        nArray[125] = 161;
        nArray[126] = 141;
        nArray[127] = 61;
        nArray[128] = 151;
        nArray[130] = 207;
        nArray[131] = 43;
        nArray[132] = 118;
        nArray[133] = 130;
        nArray[134] = 214;
        nArray[135] = 27;
        nArray[136] = 181;
        nArray[137] = 175;
        nArray[138] = 106;
        nArray[139] = 80;
        nArray[140] = 69;
        nArray[141] = 243;
        nArray[142] = 48;
        nArray[143] = 239;
        nArray[144] = 63;
        nArray[145] = 85;
        nArray[146] = 162;
        nArray[147] = 234;
        nArray[148] = 101;
        nArray[149] = 186;
        nArray[150] = 47;
        nArray[151] = 192;
        nArray[152] = 222;
        nArray[153] = 28;
        nArray[154] = 253;
        nArray[155] = 77;
        nArray[156] = 146;
        nArray[157] = 117;
        nArray[158] = 6;
        nArray[159] = 138;
        nArray[160] = 178;
        nArray[161] = 230;
        nArray[162] = 14;
        nArray[163] = 31;
        nArray[164] = 98;
        nArray[165] = 212;
        nArray[166] = 168;
        nArray[167] = 150;
        nArray[168] = 249;
        nArray[169] = 197;
        nArray[170] = 37;
        nArray[171] = 89;
        nArray[172] = 132;
        nArray[173] = 114;
        nArray[174] = 57;
        nArray[175] = 76;
        nArray[176] = 94;
        nArray[177] = 120;
        nArray[178] = 56;
        nArray[179] = 140;
        nArray[180] = 209;
        nArray[181] = 165;
        nArray[182] = 226;
        nArray[183] = 97;
        nArray[184] = 179;
        nArray[185] = 33;
        nArray[186] = 156;
        nArray[187] = 30;
        nArray[188] = 67;
        nArray[189] = 199;
        nArray[190] = 252;
        nArray[191] = 4;
        nArray[192] = 81;
        nArray[193] = 153;
        nArray[194] = 109;
        nArray[195] = 13;
        nArray[196] = 250;
        nArray[197] = 223;
        nArray[198] = 126;
        nArray[199] = 36;
        nArray[200] = 59;
        nArray[201] = 171;
        nArray[202] = 206;
        nArray[203] = 17;
        nArray[204] = 143;
        nArray[205] = 78;
        nArray[206] = 183;
        nArray[207] = 235;
        nArray[208] = 60;
        nArray[209] = 129;
        nArray[210] = 148;
        nArray[211] = 247;
        nArray[212] = 185;
        nArray[213] = 19;
        nArray[214] = 44;
        nArray[215] = 211;
        nArray[216] = 231;
        nArray[217] = 110;
        nArray[218] = 196;
        nArray[219] = 3;
        nArray[220] = 86;
        nArray[221] = 68;
        nArray[222] = 127;
        nArray[223] = 169;
        nArray[224] = 42;
        nArray[225] = 187;
        nArray[226] = 193;
        nArray[227] = 83;
        nArray[228] = 220;
        nArray[229] = 11;
        nArray[230] = 157;
        nArray[231] = 108;
        nArray[232] = 49;
        nArray[233] = 116;
        nArray[234] = 246;
        nArray[235] = 70;
        nArray[236] = 172;
        nArray[237] = 137;
        nArray[238] = 20;
        nArray[239] = 225;
        nArray[240] = 22;
        nArray[241] = 58;
        nArray[242] = 105;
        nArray[243] = 9;
        nArray[244] = 112;
        nArray[245] = 182;
        nArray[246] = 208;
        nArray[247] = 237;
        nArray[248] = 204;
        nArray[249] = 66;
        nArray[250] = 152;
        nArray[251] = 164;
        nArray[252] = 40;
        nArray[253] = 92;
        nArray[254] = 248;
        nArray[255] = 134;
        SBOX = nArray;
        C0 = new long[256];
        C1 = new long[256];
        C2 = new long[256];
        C3 = new long[256];
        C4 = new long[256];
        C5 = new long[256];
        C6 = new long[256];
        C7 = new long[256];
        EIGHT = new short[32];
        WhirlpoolDigest.EIGHT[31] = 8;
    }

    public WhirlpoolDigest() {
        int i = 0;
        while (i < 256) {
            int v1 = SBOX[i];
            int v2 = this.maskWithReductionPolynomial(v1 << 1);
            int v4 = this.maskWithReductionPolynomial(v2 << 1);
            int v5 = v4 ^ v1;
            int v8 = this.maskWithReductionPolynomial(v4 << 1);
            int v9 = v8 ^ v1;
            WhirlpoolDigest.C0[i] = this.packIntoLong(v1, v1, v4, v1, v8, v5, v2, v9);
            WhirlpoolDigest.C1[i] = this.packIntoLong(v9, v1, v1, v4, v1, v8, v5, v2);
            WhirlpoolDigest.C2[i] = this.packIntoLong(v2, v9, v1, v1, v4, v1, v8, v5);
            WhirlpoolDigest.C3[i] = this.packIntoLong(v5, v2, v9, v1, v1, v4, v1, v8);
            WhirlpoolDigest.C4[i] = this.packIntoLong(v8, v5, v2, v9, v1, v1, v4, v1);
            WhirlpoolDigest.C5[i] = this.packIntoLong(v1, v8, v5, v2, v9, v1, v1, v4);
            WhirlpoolDigest.C6[i] = this.packIntoLong(v4, v1, v8, v5, v2, v9, v1, v1);
            WhirlpoolDigest.C7[i] = this.packIntoLong(v1, v4, v1, v8, v5, v2, v9, v1);
            ++i;
        }
        this._rc[0] = 0L;
        int r = 1;
        while (r <= 10) {
            int i2 = 8 * (r - 1);
            this._rc[r] = C0[i2] & 0xFF00000000000000L ^ C1[i2 + 1] & 0xFF000000000000L ^ C2[i2 + 2] & 0xFF0000000000L ^ C3[i2 + 3] & 0xFF00000000L ^ C4[i2 + 4] & 0xFF000000L ^ C5[i2 + 5] & 0xFF0000L ^ C6[i2 + 6] & 0xFF00L ^ C7[i2 + 7] & 0xFFL;
            ++r;
        }
    }

    private long packIntoLong(int b7, int b6, int b5, int b4, int b3, int b2, int b1, int b0) {
        return (long)b7 << 56 ^ (long)b6 << 48 ^ (long)b5 << 40 ^ (long)b4 << 32 ^ (long)b3 << 24 ^ (long)b2 << 16 ^ (long)b1 << 8 ^ (long)b0;
    }

    private int maskWithReductionPolynomial(int input) {
        int rv = input;
        if ((long)rv >= 256L) {
            rv ^= 0x11D;
        }
        return rv;
    }

    public WhirlpoolDigest(WhirlpoolDigest originalDigest) {
        System.arraycopy(originalDigest._rc, 0, this._rc, 0, this._rc.length);
        System.arraycopy(originalDigest._buffer, 0, this._buffer, 0, this._buffer.length);
        this._bufferPos = originalDigest._bufferPos;
        System.arraycopy(originalDigest._bitCount, 0, this._bitCount, 0, this._bitCount.length);
        System.arraycopy(originalDigest._hash, 0, this._hash, 0, this._hash.length);
        System.arraycopy(originalDigest._K, 0, this._K, 0, this._K.length);
        System.arraycopy(originalDigest._L, 0, this._L, 0, this._L.length);
        System.arraycopy(originalDigest._block, 0, this._block, 0, this._block.length);
        System.arraycopy(originalDigest._state, 0, this._state, 0, this._state.length);
    }

    public String getAlgorithmName() {
        return "Whirlpool";
    }

    public int getDigestSize() {
        return 64;
    }

    public int doFinal(byte[] out, int outOff) {
        this.finish();
        int i = 0;
        while (i < 8) {
            this.convertLongToByteArray(this._hash[i], out, outOff + i * 8);
            ++i;
        }
        this.reset();
        return this.getDigestSize();
    }

    public void reset() {
        this._bufferPos = 0;
        Arrays.fill(this._bitCount, (short)0);
        Arrays.fill(this._buffer, (byte)0);
        Arrays.fill(this._hash, 0L);
        Arrays.fill(this._K, 0L);
        Arrays.fill(this._L, 0L);
        Arrays.fill(this._block, 0L);
        Arrays.fill(this._state, 0L);
    }

    private void processFilledBuffer(byte[] in, int inOff) {
        int i = 0;
        while (i < this._state.length) {
            this._block[i] = this.bytesToLongFromBuffer(this._buffer, i * 8);
            ++i;
        }
        this.processBlock();
        this._bufferPos = 0;
        Arrays.fill(this._buffer, (byte)0);
    }

    private long bytesToLongFromBuffer(byte[] buffer, int startPos) {
        long rv = ((long)buffer[startPos + 0] & 0xFFL) << 56 | ((long)buffer[startPos + 1] & 0xFFL) << 48 | ((long)buffer[startPos + 2] & 0xFFL) << 40 | ((long)buffer[startPos + 3] & 0xFFL) << 32 | ((long)buffer[startPos + 4] & 0xFFL) << 24 | ((long)buffer[startPos + 5] & 0xFFL) << 16 | ((long)buffer[startPos + 6] & 0xFFL) << 8 | (long)buffer[startPos + 7] & 0xFFL;
        return rv;
    }

    private void convertLongToByteArray(long inputLong, byte[] outputArray, int offSet) {
        int i = 0;
        while (i < 8) {
            outputArray[offSet + i] = (byte)(inputLong >> 56 - i * 8 & 0xFFL);
            ++i;
        }
    }

    protected void processBlock() {
        int i = 0;
        while (i < 8) {
            this._K[i] = this._hash[i];
            this._state[i] = this._block[i] ^ this._K[i];
            ++i;
        }
        int round = 1;
        while (round <= 10) {
            int i2 = 0;
            while (i2 < 8) {
                this._L[i2] = 0L;
                int n = i2;
                this._L[n] = this._L[n] ^ C0[(int)(this._K[i2 - 0 & 7] >>> 56) & 0xFF];
                int n2 = i2;
                this._L[n2] = this._L[n2] ^ C1[(int)(this._K[i2 - 1 & 7] >>> 48) & 0xFF];
                int n3 = i2;
                this._L[n3] = this._L[n3] ^ C2[(int)(this._K[i2 - 2 & 7] >>> 40) & 0xFF];
                int n4 = i2;
                this._L[n4] = this._L[n4] ^ C3[(int)(this._K[i2 - 3 & 7] >>> 32) & 0xFF];
                int n5 = i2;
                this._L[n5] = this._L[n5] ^ C4[(int)(this._K[i2 - 4 & 7] >>> 24) & 0xFF];
                int n6 = i2;
                this._L[n6] = this._L[n6] ^ C5[(int)(this._K[i2 - 5 & 7] >>> 16) & 0xFF];
                int n7 = i2;
                this._L[n7] = this._L[n7] ^ C6[(int)(this._K[i2 - 6 & 7] >>> 8) & 0xFF];
                int n8 = i2;
                this._L[n8] = this._L[n8] ^ C7[(int)this._K[i2 - 7 & 7] & 0xFF];
                ++i2;
            }
            System.arraycopy(this._L, 0, this._K, 0, this._K.length);
            this._K[0] = this._K[0] ^ this._rc[round];
            i2 = 0;
            while (i2 < 8) {
                this._L[i2] = this._K[i2];
                int n = i2;
                this._L[n] = this._L[n] ^ C0[(int)(this._state[i2 - 0 & 7] >>> 56) & 0xFF];
                int n9 = i2;
                this._L[n9] = this._L[n9] ^ C1[(int)(this._state[i2 - 1 & 7] >>> 48) & 0xFF];
                int n10 = i2;
                this._L[n10] = this._L[n10] ^ C2[(int)(this._state[i2 - 2 & 7] >>> 40) & 0xFF];
                int n11 = i2;
                this._L[n11] = this._L[n11] ^ C3[(int)(this._state[i2 - 3 & 7] >>> 32) & 0xFF];
                int n12 = i2;
                this._L[n12] = this._L[n12] ^ C4[(int)(this._state[i2 - 4 & 7] >>> 24) & 0xFF];
                int n13 = i2;
                this._L[n13] = this._L[n13] ^ C5[(int)(this._state[i2 - 5 & 7] >>> 16) & 0xFF];
                int n14 = i2;
                this._L[n14] = this._L[n14] ^ C6[(int)(this._state[i2 - 6 & 7] >>> 8) & 0xFF];
                int n15 = i2;
                this._L[n15] = this._L[n15] ^ C7[(int)this._state[i2 - 7 & 7] & 0xFF];
                ++i2;
            }
            System.arraycopy(this._L, 0, this._state, 0, this._state.length);
            ++round;
        }
        i = 0;
        while (i < 8) {
            int n = i;
            this._hash[n] = this._hash[n] ^ (this._state[i] ^ this._block[i]);
            ++i;
        }
    }

    public void update(byte in) {
        this._buffer[this._bufferPos] = in;
        ++this._bufferPos;
        if (this._bufferPos == this._buffer.length) {
            this.processFilledBuffer(this._buffer, 0);
        }
        this.increment();
    }

    private void increment() {
        int carry = 0;
        int i = this._bitCount.length - 1;
        while (i >= 0) {
            int sum = (this._bitCount[i] & 0xFF) + EIGHT[i] + carry;
            carry = sum >>> 8;
            this._bitCount[i] = (short)(sum & 0xFF);
            --i;
        }
    }

    public void update(byte[] in, int inOff, int len) {
        while (len > 0) {
            this.update(in[inOff]);
            ++inOff;
            --len;
        }
    }

    private void finish() {
        byte[] bitLength = this.copyBitLength();
        int n = this._bufferPos++;
        this._buffer[n] = (byte)(this._buffer[n] | 0x80);
        if (this._bufferPos == this._buffer.length) {
            this.processFilledBuffer(this._buffer, 0);
        }
        if (this._bufferPos > 32) {
            while (this._bufferPos != 0) {
                this.update((byte)0);
            }
        }
        while (this._bufferPos <= 32) {
            this.update((byte)0);
        }
        System.arraycopy(bitLength, 0, this._buffer, 32, bitLength.length);
        this.processFilledBuffer(this._buffer, 0);
    }

    private byte[] copyBitLength() {
        byte[] rv = new byte[32];
        int i = 0;
        while (i < rv.length) {
            rv[i] = (byte)(this._bitCount[i] & 0xFF);
            ++i;
        }
        return rv;
    }

    public int getByteLength() {
        return 64;
    }
}

