/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.encodings;

import com.sansec.crypto.AsymmetricBlockCipher;
import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.InvalidCipherTextException;
import com.sansec.crypto.engines.SM2EncryptGBEngine;

public class SM2EncryptGBEncoding
implements AsymmetricBlockCipher {
    private SM2EncryptGBEngine engine;
    private boolean forEncryption;
    public static final int MAX_BLOCK_LENGTH = 136;

    public SM2EncryptGBEncoding(SM2EncryptGBEngine cipher) {
        this.engine = cipher;
    }

    public SM2EncryptGBEngine getUnderlyingCipher() {
        return this.engine;
    }

    public void init(boolean forEncryption, CipherParameters param) {
        this.engine.init(forEncryption, param);
        this.forEncryption = forEncryption;
    }

    public int getInputBlockSize() {
        int baseBlockSize = this.engine.getInputBlockSize();
        return baseBlockSize;
    }

    public int getOutputBlockSize() {
        int baseBlockSize = this.engine.getOutputBlockSize();
        return baseBlockSize;
    }

    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (this.forEncryption) {
            return this.encodeBlock(in, inOff, inLen);
        }
        return this.decodeBlock(in, inOff, inLen);
    }

    private byte[] encodeBlock(byte[] in, int inOff, int inLen) {
        if (inLen > 136) {
            throw new IllegalArgumentException("input data too large");
        }
        return this.engine.processBlock(in, inOff, inLen);
    }

    private byte[] decodeBlock(byte[] in, int inOff, int inLen) {
        byte[] block = this.engine.processBlock(in, inOff, inLen);
        return block;
    }
}

