/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.encodings;

import com.sansec.crypto.AsymmetricBlockCipher;
import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.InvalidCipherTextException;
import com.sansec.crypto.engines.SM2EncryptOldEngine;

public class SM2EncryptOldEncoding
implements AsymmetricBlockCipher {
    private SM2EncryptOldEngine engine;
    private boolean forEncryption;
    public static final int MAX_BLOCK_LENGTH = 32;

    public SM2EncryptOldEncoding(SM2EncryptOldEngine cipher) {
        this.engine = cipher;
    }

    public SM2EncryptOldEngine getUnderlyingCipher() {
        return this.engine;
    }

    public void init(boolean forEncryption, CipherParameters param) {
        this.engine.init(forEncryption, param);
        this.forEncryption = forEncryption;
    }

    public int getInputBlockSize() {
        int baseBlockSize = this.engine.getInputBlockSize();
        baseBlockSize = this.forEncryption ? 32 : 128;
        return baseBlockSize;
    }

    public int getOutputBlockSize() {
        int baseBlockSize = this.engine.getOutputBlockSize();
        baseBlockSize = this.forEncryption ? 128 : 32;
        return baseBlockSize;
    }

    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (this.forEncryption) {
            return this.encodeBlock(in, inOff, inLen);
        }
        return this.decodeBlock(in, inOff, inLen);
    }

    private byte[] encodeBlock(byte[] in, int inOff, int inLen) {
        byte[] block = new byte[32];
        if (inLen > 32) {
            throw new IllegalArgumentException("input data too large");
        }
        System.arraycopy(in, inOff, block, 0, inLen);
        return this.engine.processBlock(block, 0, block.length);
    }

    private byte[] decodeBlock(byte[] in, int inOff, int inLen) {
        byte[] block = this.engine.processBlock(in, inOff, inLen);
        int index = 0;
        int i = 0;
        while (i < 32) {
            if (block[i] == 0) break;
            ++index;
            ++i;
        }
        if (index == 0) {
            throw new IllegalArgumentException("plain text first byte is 0x00");
        }
        byte[] tmp = new byte[index];
        System.arraycopy(block, 0, tmp, 0, index);
        return tmp;
    }
}

