/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.encodings;

import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.InvalidCipherTextException;
import com.sansec.crypto.engines.SM2SignEngine;
import com.sansec.crypto.params.AsymmetricKeyParameter;
import com.sansec.crypto.params.ParametersWithRandom;
import java.security.SecureRandom;

public class SM2SignatureEncoding {
    private SM2SignEngine engine;
    private SecureRandom random;
    private boolean forEncryption;
    private boolean forPrivateKey;
    public static final int MAX_BLOCK_LENGTH = 32;

    public SM2SignatureEncoding(SM2SignEngine cipher) {
        this.engine = cipher;
    }

    public SM2SignEngine getUnderlyingCipher() {
        return this.engine;
    }

    public void init(boolean forEncryption, CipherParameters param) {
        AsymmetricKeyParameter kParam;
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.random = rParam.getRandom();
            kParam = (AsymmetricKeyParameter)rParam.getParameters();
        } else {
            this.random = new SecureRandom();
            kParam = (AsymmetricKeyParameter)param;
        }
        this.engine.init(forEncryption, param);
        this.forPrivateKey = kParam.isPrivate();
        this.forEncryption = forEncryption;
    }

    public int getInputBlockSize() {
        int baseBlockSize = this.engine.getInputBlockSize();
        return baseBlockSize;
    }

    public int getOutputBlockSize() {
        int baseBlockSize = this.engine.getOutputBlockSize();
        return baseBlockSize;
    }

    public byte[] sign(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        byte[] block = new byte[32];
        if (inLen > 32) {
            System.arraycopy(in, inOff, block, 0, 32);
        } else {
            System.arraycopy(in, inOff, block, 0, inLen);
        }
        return this.engine.sign(block, 0, block.length);
    }

    public boolean verify(byte[] sigBytes, int sigOff, int sigLen, byte[] in, int inOff, int inLen) {
        byte[] block = new byte[32];
        if (inLen > 32) {
            System.arraycopy(in, inOff, block, 0, 32);
        } else {
            System.arraycopy(in, inOff, block, 0, inLen);
        }
        if (sigLen > this.engine.getInputBlockSize()) {
            throw new IllegalArgumentException("input data too large");
        }
        boolean flag = this.engine.veryfiy(block, 0, block.length, sigBytes, sigOff, sigLen);
        return flag;
    }
}

