/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.engines;

import com.sansec.crypto.BlockCipher;
import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.DataLengthException;
import com.sansec.crypto.params.KeyParameter;

public class CamelliaLightEngine
implements BlockCipher {
    private static final int BLOCK_SIZE = 16;
    private static final int MASK8 = 255;
    private boolean initialized;
    private boolean _keyis128;
    private int[] subkey = new int[96];
    private int[] kw = new int[8];
    private int[] ke = new int[12];
    private int[] state = new int[4];
    private static final int[] SIGMA = new int[]{-1600231809, 1003262091, -1233459112, 1286239154, -957401297, -380665154, 1426019237, -237801700, 283453434, -563598051, -1336506174, -1276722691};
    private static final byte[] SBOX1;

    static {
        byte[] byArray = new byte[256];
        byArray[0] = 112;
        byArray[1] = -126;
        byArray[2] = 44;
        byArray[3] = -20;
        byArray[4] = -77;
        byArray[5] = 39;
        byArray[6] = -64;
        byArray[7] = -27;
        byArray[8] = -28;
        byArray[9] = -123;
        byArray[10] = 87;
        byArray[11] = 53;
        byArray[12] = -22;
        byArray[13] = 12;
        byArray[14] = -82;
        byArray[15] = 65;
        byArray[16] = 35;
        byArray[17] = -17;
        byArray[18] = 107;
        byArray[19] = -109;
        byArray[20] = 69;
        byArray[21] = 25;
        byArray[22] = -91;
        byArray[23] = 33;
        byArray[24] = -19;
        byArray[25] = 14;
        byArray[26] = 79;
        byArray[27] = 78;
        byArray[28] = 29;
        byArray[29] = 101;
        byArray[30] = -110;
        byArray[31] = -67;
        byArray[32] = -122;
        byArray[33] = -72;
        byArray[34] = -81;
        byArray[35] = -113;
        byArray[36] = 124;
        byArray[37] = -21;
        byArray[38] = 31;
        byArray[39] = -50;
        byArray[40] = 62;
        byArray[41] = 48;
        byArray[42] = -36;
        byArray[43] = 95;
        byArray[44] = 94;
        byArray[45] = -59;
        byArray[46] = 11;
        byArray[47] = 26;
        byArray[48] = -90;
        byArray[49] = -31;
        byArray[50] = 57;
        byArray[51] = -54;
        byArray[52] = -43;
        byArray[53] = 71;
        byArray[54] = 93;
        byArray[55] = 61;
        byArray[56] = -39;
        byArray[57] = 1;
        byArray[58] = 90;
        byArray[59] = -42;
        byArray[60] = 81;
        byArray[61] = 86;
        byArray[62] = 108;
        byArray[63] = 77;
        byArray[64] = -117;
        byArray[65] = 13;
        byArray[66] = -102;
        byArray[67] = 102;
        byArray[68] = -5;
        byArray[69] = -52;
        byArray[70] = -80;
        byArray[71] = 45;
        byArray[72] = 116;
        byArray[73] = 18;
        byArray[74] = 43;
        byArray[75] = 32;
        byArray[76] = -16;
        byArray[77] = -79;
        byArray[78] = -124;
        byArray[79] = -103;
        byArray[80] = -33;
        byArray[81] = 76;
        byArray[82] = -53;
        byArray[83] = -62;
        byArray[84] = 52;
        byArray[85] = 126;
        byArray[86] = 118;
        byArray[87] = 5;
        byArray[88] = 109;
        byArray[89] = -73;
        byArray[90] = -87;
        byArray[91] = 49;
        byArray[92] = -47;
        byArray[93] = 23;
        byArray[94] = 4;
        byArray[95] = -41;
        byArray[96] = 20;
        byArray[97] = 88;
        byArray[98] = 58;
        byArray[99] = 97;
        byArray[100] = -34;
        byArray[101] = 27;
        byArray[102] = 17;
        byArray[103] = 28;
        byArray[104] = 50;
        byArray[105] = 15;
        byArray[106] = -100;
        byArray[107] = 22;
        byArray[108] = 83;
        byArray[109] = 24;
        byArray[110] = -14;
        byArray[111] = 34;
        byArray[112] = -2;
        byArray[113] = 68;
        byArray[114] = -49;
        byArray[115] = -78;
        byArray[116] = -61;
        byArray[117] = -75;
        byArray[118] = 122;
        byArray[119] = -111;
        byArray[120] = 36;
        byArray[121] = 8;
        byArray[122] = -24;
        byArray[123] = -88;
        byArray[124] = 96;
        byArray[125] = -4;
        byArray[126] = 105;
        byArray[127] = 80;
        byArray[128] = -86;
        byArray[129] = -48;
        byArray[130] = -96;
        byArray[131] = 125;
        byArray[132] = -95;
        byArray[133] = -119;
        byArray[134] = 98;
        byArray[135] = -105;
        byArray[136] = 84;
        byArray[137] = 91;
        byArray[138] = 30;
        byArray[139] = -107;
        byArray[140] = -32;
        byArray[141] = -1;
        byArray[142] = 100;
        byArray[143] = -46;
        byArray[144] = 16;
        byArray[145] = -60;
        byArray[147] = 72;
        byArray[148] = -93;
        byArray[149] = -9;
        byArray[150] = 117;
        byArray[151] = -37;
        byArray[152] = -118;
        byArray[153] = 3;
        byArray[154] = -26;
        byArray[155] = -38;
        byArray[156] = 9;
        byArray[157] = 63;
        byArray[158] = -35;
        byArray[159] = -108;
        byArray[160] = -121;
        byArray[161] = 92;
        byArray[162] = -125;
        byArray[163] = 2;
        byArray[164] = -51;
        byArray[165] = 74;
        byArray[166] = -112;
        byArray[167] = 51;
        byArray[168] = 115;
        byArray[169] = 103;
        byArray[170] = -10;
        byArray[171] = -13;
        byArray[172] = -99;
        byArray[173] = 127;
        byArray[174] = -65;
        byArray[175] = -30;
        byArray[176] = 82;
        byArray[177] = -101;
        byArray[178] = -40;
        byArray[179] = 38;
        byArray[180] = -56;
        byArray[181] = 55;
        byArray[182] = -58;
        byArray[183] = 59;
        byArray[184] = -127;
        byArray[185] = -106;
        byArray[186] = 111;
        byArray[187] = 75;
        byArray[188] = 19;
        byArray[189] = -66;
        byArray[190] = 99;
        byArray[191] = 46;
        byArray[192] = -23;
        byArray[193] = 121;
        byArray[194] = -89;
        byArray[195] = -116;
        byArray[196] = -97;
        byArray[197] = 110;
        byArray[198] = -68;
        byArray[199] = -114;
        byArray[200] = 41;
        byArray[201] = -11;
        byArray[202] = -7;
        byArray[203] = -74;
        byArray[204] = 47;
        byArray[205] = -3;
        byArray[206] = -76;
        byArray[207] = 89;
        byArray[208] = 120;
        byArray[209] = -104;
        byArray[210] = 6;
        byArray[211] = 106;
        byArray[212] = -25;
        byArray[213] = 70;
        byArray[214] = 113;
        byArray[215] = -70;
        byArray[216] = -44;
        byArray[217] = 37;
        byArray[218] = -85;
        byArray[219] = 66;
        byArray[220] = -120;
        byArray[221] = -94;
        byArray[222] = -115;
        byArray[223] = -6;
        byArray[224] = 114;
        byArray[225] = 7;
        byArray[226] = -71;
        byArray[227] = 85;
        byArray[228] = -8;
        byArray[229] = -18;
        byArray[230] = -84;
        byArray[231] = 10;
        byArray[232] = 54;
        byArray[233] = 73;
        byArray[234] = 42;
        byArray[235] = 104;
        byArray[236] = 60;
        byArray[237] = 56;
        byArray[238] = -15;
        byArray[239] = -92;
        byArray[240] = 64;
        byArray[241] = 40;
        byArray[242] = -45;
        byArray[243] = 123;
        byArray[244] = -69;
        byArray[245] = -55;
        byArray[246] = 67;
        byArray[247] = -63;
        byArray[248] = 21;
        byArray[249] = -29;
        byArray[250] = -83;
        byArray[251] = -12;
        byArray[252] = 119;
        byArray[253] = -57;
        byArray[254] = -128;
        byArray[255] = -98;
        SBOX1 = byArray;
    }

    private static int rightRotate(int x, int s) {
        return (x >>> s) + (x << 32 - s);
    }

    private static int leftRotate(int x, int s) {
        return (x << s) + (x >>> 32 - s);
    }

    private static void roldq(int rot, int[] ki, int ioff, int[] ko, int ooff) {
        ko[0 + ooff] = ki[0 + ioff] << rot | ki[1 + ioff] >>> 32 - rot;
        ko[1 + ooff] = ki[1 + ioff] << rot | ki[2 + ioff] >>> 32 - rot;
        ko[2 + ooff] = ki[2 + ioff] << rot | ki[3 + ioff] >>> 32 - rot;
        ko[3 + ooff] = ki[3 + ioff] << rot | ki[0 + ioff] >>> 32 - rot;
        ki[0 + ioff] = ko[0 + ooff];
        ki[1 + ioff] = ko[1 + ooff];
        ki[2 + ioff] = ko[2 + ooff];
        ki[3 + ioff] = ko[3 + ooff];
    }

    private static void decroldq(int rot, int[] ki, int ioff, int[] ko, int ooff) {
        ko[2 + ooff] = ki[0 + ioff] << rot | ki[1 + ioff] >>> 32 - rot;
        ko[3 + ooff] = ki[1 + ioff] << rot | ki[2 + ioff] >>> 32 - rot;
        ko[0 + ooff] = ki[2 + ioff] << rot | ki[3 + ioff] >>> 32 - rot;
        ko[1 + ooff] = ki[3 + ioff] << rot | ki[0 + ioff] >>> 32 - rot;
        ki[0 + ioff] = ko[2 + ooff];
        ki[1 + ioff] = ko[3 + ooff];
        ki[2 + ioff] = ko[0 + ooff];
        ki[3 + ioff] = ko[1 + ooff];
    }

    private static void roldqo32(int rot, int[] ki, int ioff, int[] ko, int ooff) {
        ko[0 + ooff] = ki[1 + ioff] << rot - 32 | ki[2 + ioff] >>> 64 - rot;
        ko[1 + ooff] = ki[2 + ioff] << rot - 32 | ki[3 + ioff] >>> 64 - rot;
        ko[2 + ooff] = ki[3 + ioff] << rot - 32 | ki[0 + ioff] >>> 64 - rot;
        ko[3 + ooff] = ki[0 + ioff] << rot - 32 | ki[1 + ioff] >>> 64 - rot;
        ki[0 + ioff] = ko[0 + ooff];
        ki[1 + ioff] = ko[1 + ooff];
        ki[2 + ioff] = ko[2 + ooff];
        ki[3 + ioff] = ko[3 + ooff];
    }

    private static void decroldqo32(int rot, int[] ki, int ioff, int[] ko, int ooff) {
        ko[2 + ooff] = ki[1 + ioff] << rot - 32 | ki[2 + ioff] >>> 64 - rot;
        ko[3 + ooff] = ki[2 + ioff] << rot - 32 | ki[3 + ioff] >>> 64 - rot;
        ko[0 + ooff] = ki[3 + ioff] << rot - 32 | ki[0 + ioff] >>> 64 - rot;
        ko[1 + ooff] = ki[0 + ioff] << rot - 32 | ki[1 + ioff] >>> 64 - rot;
        ki[0 + ioff] = ko[2 + ooff];
        ki[1 + ioff] = ko[3 + ooff];
        ki[2 + ioff] = ko[0 + ooff];
        ki[3 + ioff] = ko[1 + ooff];
    }

    private int bytes2int(byte[] src, int offset) {
        int word = 0;
        int i = 0;
        while (i < 4) {
            word = (word << 8) + (src[i + offset] & 0xFF);
            ++i;
        }
        return word;
    }

    private void int2bytes(int word, byte[] dst, int offset) {
        int i = 0;
        while (i < 4) {
            dst[3 - i + offset] = (byte)word;
            word >>>= 8;
            ++i;
        }
    }

    private byte lRot8(byte v, int rot) {
        return (byte)(v << rot | (v & 0xFF) >>> 8 - rot);
    }

    private int sbox2(int x) {
        return this.lRot8(SBOX1[x], 1) & 0xFF;
    }

    private int sbox3(int x) {
        return this.lRot8(SBOX1[x], 7) & 0xFF;
    }

    private int sbox4(int x) {
        return SBOX1[this.lRot8((byte)x, 1) & 0xFF] & 0xFF;
    }

    private void camelliaF2(int[] s, int[] skey, int keyoff) {
        int t1 = s[0] ^ skey[0 + keyoff];
        int u = this.sbox4(t1 & 0xFF);
        u |= this.sbox3(t1 >>> 8 & 0xFF) << 8;
        u |= this.sbox2(t1 >>> 16 & 0xFF) << 16;
        u |= (SBOX1[t1 >>> 24 & 0xFF] & 0xFF) << 24;
        int t2 = s[1] ^ skey[1 + keyoff];
        int v = SBOX1[t2 & 0xFF] & 0xFF;
        v |= this.sbox4(t2 >>> 8 & 0xFF) << 8;
        v |= this.sbox3(t2 >>> 16 & 0xFF) << 16;
        v |= this.sbox2(t2 >>> 24 & 0xFF) << 24;
        v = CamelliaLightEngine.leftRotate(v, 8);
        u ^= v;
        v = CamelliaLightEngine.leftRotate(v, 8) ^ u;
        u = CamelliaLightEngine.rightRotate(u, 8) ^ v;
        s[2] = s[2] ^ (CamelliaLightEngine.leftRotate(v, 16) ^ u);
        s[3] = s[3] ^ CamelliaLightEngine.leftRotate(u, 8);
        t1 = s[2] ^ skey[2 + keyoff];
        u = this.sbox4(t1 & 0xFF);
        u |= this.sbox3(t1 >>> 8 & 0xFF) << 8;
        u |= this.sbox2(t1 >>> 16 & 0xFF) << 16;
        u |= (SBOX1[t1 >>> 24 & 0xFF] & 0xFF) << 24;
        t2 = s[3] ^ skey[3 + keyoff];
        v = SBOX1[t2 & 0xFF] & 0xFF;
        v |= this.sbox4(t2 >>> 8 & 0xFF) << 8;
        v |= this.sbox3(t2 >>> 16 & 0xFF) << 16;
        v |= this.sbox2(t2 >>> 24 & 0xFF) << 24;
        v = CamelliaLightEngine.leftRotate(v, 8);
        u ^= v;
        v = CamelliaLightEngine.leftRotate(v, 8) ^ u;
        u = CamelliaLightEngine.rightRotate(u, 8) ^ v;
        s[0] = s[0] ^ (CamelliaLightEngine.leftRotate(v, 16) ^ u);
        s[1] = s[1] ^ CamelliaLightEngine.leftRotate(u, 8);
    }

    private void camelliaFLs(int[] s, int[] fkey, int keyoff) {
        s[1] = s[1] ^ CamelliaLightEngine.leftRotate(s[0] & fkey[0 + keyoff], 1);
        s[0] = s[0] ^ (fkey[1 + keyoff] | s[1]);
        s[2] = s[2] ^ (fkey[3 + keyoff] | s[3]);
        s[3] = s[3] ^ CamelliaLightEngine.leftRotate(fkey[2 + keyoff] & s[2], 1);
    }

    private void setKey(boolean forEncryption, byte[] key) {
        int[] k = new int[8];
        int[] ka = new int[4];
        int[] kb = new int[4];
        int[] t = new int[4];
        switch (key.length) {
            case 16: {
                this._keyis128 = true;
                k[0] = this.bytes2int(key, 0);
                k[1] = this.bytes2int(key, 4);
                k[2] = this.bytes2int(key, 8);
                k[3] = this.bytes2int(key, 12);
                k[7] = 0;
                k[6] = 0;
                k[5] = 0;
                k[4] = 0;
                break;
            }
            case 24: {
                k[0] = this.bytes2int(key, 0);
                k[1] = this.bytes2int(key, 4);
                k[2] = this.bytes2int(key, 8);
                k[3] = this.bytes2int(key, 12);
                k[4] = this.bytes2int(key, 16);
                k[5] = this.bytes2int(key, 20);
                k[6] = ~k[4];
                k[7] = ~k[5];
                this._keyis128 = false;
                break;
            }
            case 32: {
                k[0] = this.bytes2int(key, 0);
                k[1] = this.bytes2int(key, 4);
                k[2] = this.bytes2int(key, 8);
                k[3] = this.bytes2int(key, 12);
                k[4] = this.bytes2int(key, 16);
                k[5] = this.bytes2int(key, 20);
                k[6] = this.bytes2int(key, 24);
                k[7] = this.bytes2int(key, 28);
                this._keyis128 = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("key sizes are only 16/24/32 bytes.");
            }
        }
        int i = 0;
        while (i < 4) {
            ka[i] = k[i] ^ k[i + 4];
            ++i;
        }
        this.camelliaF2(ka, SIGMA, 0);
        i = 0;
        while (i < 4) {
            int n = i;
            ka[n] = ka[n] ^ k[i];
            ++i;
        }
        this.camelliaF2(ka, SIGMA, 4);
        if (this._keyis128) {
            if (forEncryption) {
                this.kw[0] = k[0];
                this.kw[1] = k[1];
                this.kw[2] = k[2];
                this.kw[3] = k[3];
                CamelliaLightEngine.roldq(15, k, 0, this.subkey, 4);
                CamelliaLightEngine.roldq(30, k, 0, this.subkey, 12);
                CamelliaLightEngine.roldq(15, k, 0, t, 0);
                this.subkey[18] = t[2];
                this.subkey[19] = t[3];
                CamelliaLightEngine.roldq(17, k, 0, this.ke, 4);
                CamelliaLightEngine.roldq(17, k, 0, this.subkey, 24);
                CamelliaLightEngine.roldq(17, k, 0, this.subkey, 32);
                this.subkey[0] = ka[0];
                this.subkey[1] = ka[1];
                this.subkey[2] = ka[2];
                this.subkey[3] = ka[3];
                CamelliaLightEngine.roldq(15, ka, 0, this.subkey, 8);
                CamelliaLightEngine.roldq(15, ka, 0, this.ke, 0);
                CamelliaLightEngine.roldq(15, ka, 0, t, 0);
                this.subkey[16] = t[0];
                this.subkey[17] = t[1];
                CamelliaLightEngine.roldq(15, ka, 0, this.subkey, 20);
                CamelliaLightEngine.roldqo32(34, ka, 0, this.subkey, 28);
                CamelliaLightEngine.roldq(17, ka, 0, this.kw, 4);
            } else {
                this.kw[4] = k[0];
                this.kw[5] = k[1];
                this.kw[6] = k[2];
                this.kw[7] = k[3];
                CamelliaLightEngine.decroldq(15, k, 0, this.subkey, 28);
                CamelliaLightEngine.decroldq(30, k, 0, this.subkey, 20);
                CamelliaLightEngine.decroldq(15, k, 0, t, 0);
                this.subkey[16] = t[0];
                this.subkey[17] = t[1];
                CamelliaLightEngine.decroldq(17, k, 0, this.ke, 0);
                CamelliaLightEngine.decroldq(17, k, 0, this.subkey, 8);
                CamelliaLightEngine.decroldq(17, k, 0, this.subkey, 0);
                this.subkey[34] = ka[0];
                this.subkey[35] = ka[1];
                this.subkey[32] = ka[2];
                this.subkey[33] = ka[3];
                CamelliaLightEngine.decroldq(15, ka, 0, this.subkey, 24);
                CamelliaLightEngine.decroldq(15, ka, 0, this.ke, 4);
                CamelliaLightEngine.decroldq(15, ka, 0, t, 0);
                this.subkey[18] = t[2];
                this.subkey[19] = t[3];
                CamelliaLightEngine.decroldq(15, ka, 0, this.subkey, 12);
                CamelliaLightEngine.decroldqo32(34, ka, 0, this.subkey, 4);
                CamelliaLightEngine.roldq(17, ka, 0, this.kw, 0);
            }
        } else {
            i = 0;
            while (i < 4) {
                kb[i] = ka[i] ^ k[i + 4];
                ++i;
            }
            this.camelliaF2(kb, SIGMA, 8);
            if (forEncryption) {
                this.kw[0] = k[0];
                this.kw[1] = k[1];
                this.kw[2] = k[2];
                this.kw[3] = k[3];
                CamelliaLightEngine.roldqo32(45, k, 0, this.subkey, 16);
                CamelliaLightEngine.roldq(15, k, 0, this.ke, 4);
                CamelliaLightEngine.roldq(17, k, 0, this.subkey, 32);
                CamelliaLightEngine.roldqo32(34, k, 0, this.subkey, 44);
                CamelliaLightEngine.roldq(15, k, 4, this.subkey, 4);
                CamelliaLightEngine.roldq(15, k, 4, this.ke, 0);
                CamelliaLightEngine.roldq(30, k, 4, this.subkey, 24);
                CamelliaLightEngine.roldqo32(34, k, 4, this.subkey, 36);
                CamelliaLightEngine.roldq(15, ka, 0, this.subkey, 8);
                CamelliaLightEngine.roldq(30, ka, 0, this.subkey, 20);
                this.ke[8] = ka[1];
                this.ke[9] = ka[2];
                this.ke[10] = ka[3];
                this.ke[11] = ka[0];
                CamelliaLightEngine.roldqo32(49, ka, 0, this.subkey, 40);
                this.subkey[0] = kb[0];
                this.subkey[1] = kb[1];
                this.subkey[2] = kb[2];
                this.subkey[3] = kb[3];
                CamelliaLightEngine.roldq(30, kb, 0, this.subkey, 12);
                CamelliaLightEngine.roldq(30, kb, 0, this.subkey, 28);
                CamelliaLightEngine.roldqo32(51, kb, 0, this.kw, 4);
            } else {
                this.kw[4] = k[0];
                this.kw[5] = k[1];
                this.kw[6] = k[2];
                this.kw[7] = k[3];
                CamelliaLightEngine.decroldqo32(45, k, 0, this.subkey, 28);
                CamelliaLightEngine.decroldq(15, k, 0, this.ke, 4);
                CamelliaLightEngine.decroldq(17, k, 0, this.subkey, 12);
                CamelliaLightEngine.decroldqo32(34, k, 0, this.subkey, 0);
                CamelliaLightEngine.decroldq(15, k, 4, this.subkey, 40);
                CamelliaLightEngine.decroldq(15, k, 4, this.ke, 8);
                CamelliaLightEngine.decroldq(30, k, 4, this.subkey, 20);
                CamelliaLightEngine.decroldqo32(34, k, 4, this.subkey, 8);
                CamelliaLightEngine.decroldq(15, ka, 0, this.subkey, 36);
                CamelliaLightEngine.decroldq(30, ka, 0, this.subkey, 24);
                this.ke[2] = ka[1];
                this.ke[3] = ka[2];
                this.ke[0] = ka[3];
                this.ke[1] = ka[0];
                CamelliaLightEngine.decroldqo32(49, ka, 0, this.subkey, 4);
                this.subkey[46] = kb[0];
                this.subkey[47] = kb[1];
                this.subkey[44] = kb[2];
                this.subkey[45] = kb[3];
                CamelliaLightEngine.decroldq(30, kb, 0, this.subkey, 32);
                CamelliaLightEngine.decroldq(30, kb, 0, this.subkey, 16);
                CamelliaLightEngine.roldqo32(51, kb, 0, this.kw, 0);
            }
        }
    }

    private int processBlock128(byte[] in, int inOff, byte[] out, int outOff) {
        int i = 0;
        while (i < 4) {
            this.state[i] = this.bytes2int(in, inOff + i * 4);
            int n = i;
            this.state[n] = this.state[n] ^ this.kw[i];
            ++i;
        }
        this.camelliaF2(this.state, this.subkey, 0);
        this.camelliaF2(this.state, this.subkey, 4);
        this.camelliaF2(this.state, this.subkey, 8);
        this.camelliaFLs(this.state, this.ke, 0);
        this.camelliaF2(this.state, this.subkey, 12);
        this.camelliaF2(this.state, this.subkey, 16);
        this.camelliaF2(this.state, this.subkey, 20);
        this.camelliaFLs(this.state, this.ke, 4);
        this.camelliaF2(this.state, this.subkey, 24);
        this.camelliaF2(this.state, this.subkey, 28);
        this.camelliaF2(this.state, this.subkey, 32);
        this.state[2] = this.state[2] ^ this.kw[4];
        this.state[3] = this.state[3] ^ this.kw[5];
        this.state[0] = this.state[0] ^ this.kw[6];
        this.state[1] = this.state[1] ^ this.kw[7];
        this.int2bytes(this.state[2], out, outOff);
        this.int2bytes(this.state[3], out, outOff + 4);
        this.int2bytes(this.state[0], out, outOff + 8);
        this.int2bytes(this.state[1], out, outOff + 12);
        return 16;
    }

    private int processBlock192or256(byte[] in, int inOff, byte[] out, int outOff) {
        int i = 0;
        while (i < 4) {
            this.state[i] = this.bytes2int(in, inOff + i * 4);
            int n = i;
            this.state[n] = this.state[n] ^ this.kw[i];
            ++i;
        }
        this.camelliaF2(this.state, this.subkey, 0);
        this.camelliaF2(this.state, this.subkey, 4);
        this.camelliaF2(this.state, this.subkey, 8);
        this.camelliaFLs(this.state, this.ke, 0);
        this.camelliaF2(this.state, this.subkey, 12);
        this.camelliaF2(this.state, this.subkey, 16);
        this.camelliaF2(this.state, this.subkey, 20);
        this.camelliaFLs(this.state, this.ke, 4);
        this.camelliaF2(this.state, this.subkey, 24);
        this.camelliaF2(this.state, this.subkey, 28);
        this.camelliaF2(this.state, this.subkey, 32);
        this.camelliaFLs(this.state, this.ke, 8);
        this.camelliaF2(this.state, this.subkey, 36);
        this.camelliaF2(this.state, this.subkey, 40);
        this.camelliaF2(this.state, this.subkey, 44);
        this.state[2] = this.state[2] ^ this.kw[4];
        this.state[3] = this.state[3] ^ this.kw[5];
        this.state[0] = this.state[0] ^ this.kw[6];
        this.state[1] = this.state[1] ^ this.kw[7];
        this.int2bytes(this.state[2], out, outOff);
        this.int2bytes(this.state[3], out, outOff + 4);
        this.int2bytes(this.state[0], out, outOff + 8);
        this.int2bytes(this.state[1], out, outOff + 12);
        return 16;
    }

    public String getAlgorithmName() {
        return "Camellia";
    }

    public int getBlockSize() {
        return 16;
    }

    public void init(boolean forEncryption, CipherParameters params) {
        if (!(params instanceof KeyParameter)) {
            throw new IllegalArgumentException("only simple KeyParameter expected.");
        }
        this.setKey(forEncryption, ((KeyParameter)params).getKey());
        this.initialized = true;
    }

    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("Camellia is not initialized");
        }
        if (inOff + 16 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 16 > out.length) {
            throw new DataLengthException("output buffer too short");
        }
        if (this._keyis128) {
            return this.processBlock128(in, inOff, out, outOff);
        }
        return this.processBlock192or256(in, inOff, out, outOff);
    }

    public void reset() {
    }
}

