/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.engines;

import com.sansec.crypto.BlockCipher;
import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.DataLengthException;

public class NullEngine
implements BlockCipher {
    private boolean initialised;
    protected static final int BLOCK_SIZE = 1;

    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        this.initialised = true;
    }

    public String getAlgorithmName() {
        return "Null";
    }

    public int getBlockSize() {
        return 1;
    }

    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("Null engine not initialised");
        }
        if (inOff + 1 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 1 > out.length) {
            throw new DataLengthException("output buffer too short");
        }
        int i = 0;
        while (i < 1) {
            out[outOff + i] = in[inOff + i];
            ++i;
        }
        return 1;
    }

    public void reset() {
    }
}

