/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.engines;

import com.sansec.crypto.BlockCipher;
import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.DataLengthException;
import com.sansec.crypto.params.KeyParameter;
import com.sansec.crypto.params.RC2Parameters;

public class RC2Engine
implements BlockCipher {
    private static byte[] piTable;
    private static final int BLOCK_SIZE = 8;
    private int[] workingKey;
    private boolean encrypting;

    static {
        byte[] byArray = new byte[256];
        byArray[0] = -39;
        byArray[1] = 120;
        byArray[2] = -7;
        byArray[3] = -60;
        byArray[4] = 25;
        byArray[5] = -35;
        byArray[6] = -75;
        byArray[7] = -19;
        byArray[8] = 40;
        byArray[9] = -23;
        byArray[10] = -3;
        byArray[11] = 121;
        byArray[12] = 74;
        byArray[13] = -96;
        byArray[14] = -40;
        byArray[15] = -99;
        byArray[16] = -58;
        byArray[17] = 126;
        byArray[18] = 55;
        byArray[19] = -125;
        byArray[20] = 43;
        byArray[21] = 118;
        byArray[22] = 83;
        byArray[23] = -114;
        byArray[24] = 98;
        byArray[25] = 76;
        byArray[26] = 100;
        byArray[27] = -120;
        byArray[28] = 68;
        byArray[29] = -117;
        byArray[30] = -5;
        byArray[31] = -94;
        byArray[32] = 23;
        byArray[33] = -102;
        byArray[34] = 89;
        byArray[35] = -11;
        byArray[36] = -121;
        byArray[37] = -77;
        byArray[38] = 79;
        byArray[39] = 19;
        byArray[40] = 97;
        byArray[41] = 69;
        byArray[42] = 109;
        byArray[43] = -115;
        byArray[44] = 9;
        byArray[45] = -127;
        byArray[46] = 125;
        byArray[47] = 50;
        byArray[48] = -67;
        byArray[49] = -113;
        byArray[50] = 64;
        byArray[51] = -21;
        byArray[52] = -122;
        byArray[53] = -73;
        byArray[54] = 123;
        byArray[55] = 11;
        byArray[56] = -16;
        byArray[57] = -107;
        byArray[58] = 33;
        byArray[59] = 34;
        byArray[60] = 92;
        byArray[61] = 107;
        byArray[62] = 78;
        byArray[63] = -126;
        byArray[64] = 84;
        byArray[65] = -42;
        byArray[66] = 101;
        byArray[67] = -109;
        byArray[68] = -50;
        byArray[69] = 96;
        byArray[70] = -78;
        byArray[71] = 28;
        byArray[72] = 115;
        byArray[73] = 86;
        byArray[74] = -64;
        byArray[75] = 20;
        byArray[76] = -89;
        byArray[77] = -116;
        byArray[78] = -15;
        byArray[79] = -36;
        byArray[80] = 18;
        byArray[81] = 117;
        byArray[82] = -54;
        byArray[83] = 31;
        byArray[84] = 59;
        byArray[85] = -66;
        byArray[86] = -28;
        byArray[87] = -47;
        byArray[88] = 66;
        byArray[89] = 61;
        byArray[90] = -44;
        byArray[91] = 48;
        byArray[92] = -93;
        byArray[93] = 60;
        byArray[94] = -74;
        byArray[95] = 38;
        byArray[96] = 111;
        byArray[97] = -65;
        byArray[98] = 14;
        byArray[99] = -38;
        byArray[100] = 70;
        byArray[101] = 105;
        byArray[102] = 7;
        byArray[103] = 87;
        byArray[104] = 39;
        byArray[105] = -14;
        byArray[106] = 29;
        byArray[107] = -101;
        byArray[108] = -68;
        byArray[109] = -108;
        byArray[110] = 67;
        byArray[111] = 3;
        byArray[112] = -8;
        byArray[113] = 17;
        byArray[114] = -57;
        byArray[115] = -10;
        byArray[116] = -112;
        byArray[117] = -17;
        byArray[118] = 62;
        byArray[119] = -25;
        byArray[120] = 6;
        byArray[121] = -61;
        byArray[122] = -43;
        byArray[123] = 47;
        byArray[124] = -56;
        byArray[125] = 102;
        byArray[126] = 30;
        byArray[127] = -41;
        byArray[128] = 8;
        byArray[129] = -24;
        byArray[130] = -22;
        byArray[131] = -34;
        byArray[132] = -128;
        byArray[133] = 82;
        byArray[134] = -18;
        byArray[135] = -9;
        byArray[136] = -124;
        byArray[137] = -86;
        byArray[138] = 114;
        byArray[139] = -84;
        byArray[140] = 53;
        byArray[141] = 77;
        byArray[142] = 106;
        byArray[143] = 42;
        byArray[144] = -106;
        byArray[145] = 26;
        byArray[146] = -46;
        byArray[147] = 113;
        byArray[148] = 90;
        byArray[149] = 21;
        byArray[150] = 73;
        byArray[151] = 116;
        byArray[152] = 75;
        byArray[153] = -97;
        byArray[154] = -48;
        byArray[155] = 94;
        byArray[156] = 4;
        byArray[157] = 24;
        byArray[158] = -92;
        byArray[159] = -20;
        byArray[160] = -62;
        byArray[161] = -32;
        byArray[162] = 65;
        byArray[163] = 110;
        byArray[164] = 15;
        byArray[165] = 81;
        byArray[166] = -53;
        byArray[167] = -52;
        byArray[168] = 36;
        byArray[169] = -111;
        byArray[170] = -81;
        byArray[171] = 80;
        byArray[172] = -95;
        byArray[173] = -12;
        byArray[174] = 112;
        byArray[175] = 57;
        byArray[176] = -103;
        byArray[177] = 124;
        byArray[178] = 58;
        byArray[179] = -123;
        byArray[180] = 35;
        byArray[181] = -72;
        byArray[182] = -76;
        byArray[183] = 122;
        byArray[184] = -4;
        byArray[185] = 2;
        byArray[186] = 54;
        byArray[187] = 91;
        byArray[188] = 37;
        byArray[189] = 85;
        byArray[190] = -105;
        byArray[191] = 49;
        byArray[192] = 45;
        byArray[193] = 93;
        byArray[194] = -6;
        byArray[195] = -104;
        byArray[196] = -29;
        byArray[197] = -118;
        byArray[198] = -110;
        byArray[199] = -82;
        byArray[200] = 5;
        byArray[201] = -33;
        byArray[202] = 41;
        byArray[203] = 16;
        byArray[204] = 103;
        byArray[205] = 108;
        byArray[206] = -70;
        byArray[207] = -55;
        byArray[208] = -45;
        byArray[210] = -26;
        byArray[211] = -49;
        byArray[212] = -31;
        byArray[213] = -98;
        byArray[214] = -88;
        byArray[215] = 44;
        byArray[216] = 99;
        byArray[217] = 22;
        byArray[218] = 1;
        byArray[219] = 63;
        byArray[220] = 88;
        byArray[221] = -30;
        byArray[222] = -119;
        byArray[223] = -87;
        byArray[224] = 13;
        byArray[225] = 56;
        byArray[226] = 52;
        byArray[227] = 27;
        byArray[228] = -85;
        byArray[229] = 51;
        byArray[230] = -1;
        byArray[231] = -80;
        byArray[232] = -69;
        byArray[233] = 72;
        byArray[234] = 12;
        byArray[235] = 95;
        byArray[236] = -71;
        byArray[237] = -79;
        byArray[238] = -51;
        byArray[239] = 46;
        byArray[240] = -59;
        byArray[241] = -13;
        byArray[242] = -37;
        byArray[243] = 71;
        byArray[244] = -27;
        byArray[245] = -91;
        byArray[246] = -100;
        byArray[247] = 119;
        byArray[248] = 10;
        byArray[249] = -90;
        byArray[250] = 32;
        byArray[251] = 104;
        byArray[252] = -2;
        byArray[253] = 127;
        byArray[254] = -63;
        byArray[255] = -83;
        piTable = byArray;
    }

    private int[] generateWorkingKey(byte[] key, int bits) {
        int x;
        int[] xKey = new int[128];
        int i = 0;
        while (i != key.length) {
            xKey[i] = key[i] & 0xFF;
            ++i;
        }
        int len = key.length;
        if (len < 128) {
            int index = 0;
            x = xKey[len - 1];
            do {
                x = piTable[x + xKey[index++] & 0xFF] & 0xFF;
                xKey[len++] = x;
            } while (len < 128);
        }
        len = bits + 7 >> 3;
        xKey[128 - len] = x = piTable[xKey[128 - len] & 255 >> (7 & -bits)] & 0xFF;
        int i2 = 128 - len - 1;
        while (i2 >= 0) {
            xKey[i2] = x = piTable[x ^ xKey[i2 + len]] & 0xFF;
            --i2;
        }
        int[] newKey = new int[64];
        int i3 = 0;
        while (i3 != newKey.length) {
            newKey[i3] = xKey[2 * i3] + (xKey[2 * i3 + 1] << 8);
            ++i3;
        }
        return newKey;
    }

    public void init(boolean encrypting, CipherParameters params) {
        this.encrypting = encrypting;
        if (params instanceof RC2Parameters) {
            RC2Parameters param = (RC2Parameters)params;
            this.workingKey = this.generateWorkingKey(param.getKey(), param.getEffectiveKeyBits());
        } else if (params instanceof KeyParameter) {
            byte[] key = ((KeyParameter)params).getKey();
            this.workingKey = this.generateWorkingKey(key, key.length * 8);
        } else {
            throw new IllegalArgumentException("invalid parameter passed to RC2 init - " + params.getClass().getName());
        }
    }

    public void reset() {
    }

    public String getAlgorithmName() {
        return "RC2";
    }

    public int getBlockSize() {
        return 8;
    }

    public final int processBlock(byte[] in, int inOff, byte[] out, int outOff) {
        if (this.workingKey == null) {
            throw new IllegalStateException("RC2 engine not initialised");
        }
        if (inOff + 8 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 8 > out.length) {
            throw new DataLengthException("output buffer too short");
        }
        if (this.encrypting) {
            this.encryptBlock(in, inOff, out, outOff);
        } else {
            this.decryptBlock(in, inOff, out, outOff);
        }
        return 8;
    }

    private int rotateWordLeft(int x, int y) {
        return (x &= 0xFFFF) << y | x >> 16 - y;
    }

    private void encryptBlock(byte[] in, int inOff, byte[] out, int outOff) {
        int x76 = ((in[inOff + 7] & 0xFF) << 8) + (in[inOff + 6] & 0xFF);
        int x54 = ((in[inOff + 5] & 0xFF) << 8) + (in[inOff + 4] & 0xFF);
        int x32 = ((in[inOff + 3] & 0xFF) << 8) + (in[inOff + 2] & 0xFF);
        int x10 = ((in[inOff + 1] & 0xFF) << 8) + (in[inOff + 0] & 0xFF);
        int i = 0;
        while (i <= 16) {
            x10 = this.rotateWordLeft(x10 + (x32 & ~x76) + (x54 & x76) + this.workingKey[i], 1);
            x32 = this.rotateWordLeft(x32 + (x54 & ~x10) + (x76 & x10) + this.workingKey[i + 1], 2);
            x54 = this.rotateWordLeft(x54 + (x76 & ~x32) + (x10 & x32) + this.workingKey[i + 2], 3);
            x76 = this.rotateWordLeft(x76 + (x10 & ~x54) + (x32 & x54) + this.workingKey[i + 3], 5);
            i += 4;
        }
        x54 += this.workingKey[(x32 += this.workingKey[(x10 += this.workingKey[x76 & 0x3F]) & 0x3F]) & 0x3F];
        x76 += this.workingKey[x54 & 0x3F];
        i = 20;
        while (i <= 40) {
            x10 = this.rotateWordLeft(x10 + (x32 & ~x76) + (x54 & x76) + this.workingKey[i], 1);
            x32 = this.rotateWordLeft(x32 + (x54 & ~x10) + (x76 & x10) + this.workingKey[i + 1], 2);
            x54 = this.rotateWordLeft(x54 + (x76 & ~x32) + (x10 & x32) + this.workingKey[i + 2], 3);
            x76 = this.rotateWordLeft(x76 + (x10 & ~x54) + (x32 & x54) + this.workingKey[i + 3], 5);
            i += 4;
        }
        x54 += this.workingKey[(x32 += this.workingKey[(x10 += this.workingKey[x76 & 0x3F]) & 0x3F]) & 0x3F];
        x76 += this.workingKey[x54 & 0x3F];
        i = 44;
        while (i < 64) {
            x10 = this.rotateWordLeft(x10 + (x32 & ~x76) + (x54 & x76) + this.workingKey[i], 1);
            x32 = this.rotateWordLeft(x32 + (x54 & ~x10) + (x76 & x10) + this.workingKey[i + 1], 2);
            x54 = this.rotateWordLeft(x54 + (x76 & ~x32) + (x10 & x32) + this.workingKey[i + 2], 3);
            x76 = this.rotateWordLeft(x76 + (x10 & ~x54) + (x32 & x54) + this.workingKey[i + 3], 5);
            i += 4;
        }
        out[outOff + 0] = (byte)x10;
        out[outOff + 1] = (byte)(x10 >> 8);
        out[outOff + 2] = (byte)x32;
        out[outOff + 3] = (byte)(x32 >> 8);
        out[outOff + 4] = (byte)x54;
        out[outOff + 5] = (byte)(x54 >> 8);
        out[outOff + 6] = (byte)x76;
        out[outOff + 7] = (byte)(x76 >> 8);
    }

    private void decryptBlock(byte[] in, int inOff, byte[] out, int outOff) {
        int x76 = ((in[inOff + 7] & 0xFF) << 8) + (in[inOff + 6] & 0xFF);
        int x54 = ((in[inOff + 5] & 0xFF) << 8) + (in[inOff + 4] & 0xFF);
        int x32 = ((in[inOff + 3] & 0xFF) << 8) + (in[inOff + 2] & 0xFF);
        int x10 = ((in[inOff + 1] & 0xFF) << 8) + (in[inOff + 0] & 0xFF);
        int i = 60;
        while (i >= 44) {
            x76 = this.rotateWordLeft(x76, 11) - ((x10 & ~x54) + (x32 & x54) + this.workingKey[i + 3]);
            x54 = this.rotateWordLeft(x54, 13) - ((x76 & ~x32) + (x10 & x32) + this.workingKey[i + 2]);
            x32 = this.rotateWordLeft(x32, 14) - ((x54 & ~x10) + (x76 & x10) + this.workingKey[i + 1]);
            x10 = this.rotateWordLeft(x10, 15) - ((x32 & ~x76) + (x54 & x76) + this.workingKey[i]);
            i -= 4;
        }
        x76 -= this.workingKey[x54 & 0x3F];
        x54 -= this.workingKey[x32 & 0x3F];
        x32 -= this.workingKey[x10 & 0x3F];
        x10 -= this.workingKey[x76 & 0x3F];
        i = 40;
        while (i >= 20) {
            x76 = this.rotateWordLeft(x76, 11) - ((x10 & ~x54) + (x32 & x54) + this.workingKey[i + 3]);
            x54 = this.rotateWordLeft(x54, 13) - ((x76 & ~x32) + (x10 & x32) + this.workingKey[i + 2]);
            x32 = this.rotateWordLeft(x32, 14) - ((x54 & ~x10) + (x76 & x10) + this.workingKey[i + 1]);
            x10 = this.rotateWordLeft(x10, 15) - ((x32 & ~x76) + (x54 & x76) + this.workingKey[i]);
            i -= 4;
        }
        x76 -= this.workingKey[x54 & 0x3F];
        x54 -= this.workingKey[x32 & 0x3F];
        x32 -= this.workingKey[x10 & 0x3F];
        x10 -= this.workingKey[x76 & 0x3F];
        i = 16;
        while (i >= 0) {
            x76 = this.rotateWordLeft(x76, 11) - ((x10 & ~x54) + (x32 & x54) + this.workingKey[i + 3]);
            x54 = this.rotateWordLeft(x54, 13) - ((x76 & ~x32) + (x10 & x32) + this.workingKey[i + 2]);
            x32 = this.rotateWordLeft(x32, 14) - ((x54 & ~x10) + (x76 & x10) + this.workingKey[i + 1]);
            x10 = this.rotateWordLeft(x10, 15) - ((x32 & ~x76) + (x54 & x76) + this.workingKey[i]);
            i -= 4;
        }
        out[outOff + 0] = (byte)x10;
        out[outOff + 1] = (byte)(x10 >> 8);
        out[outOff + 2] = (byte)x32;
        out[outOff + 3] = (byte)(x32 >> 8);
        out[outOff + 4] = (byte)x54;
        out[outOff + 5] = (byte)(x54 >> 8);
        out[outOff + 6] = (byte)x76;
        out[outOff + 7] = (byte)(x76 >> 8);
    }
}

