/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.engines;

import com.sansec.crypto.AsymmetricBlockCipher;
import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.crypto.engines.RSACoreEngine;
import com.sansec.crypto.params.ParametersWithRandom;
import com.sansec.crypto.params.RSAKeyParameters;
import com.sansec.crypto.params.RSAPrivateCrtKeyParameters;
import com.sansec.crypto.params.SwRSAKeyParams;
import com.sansec.crypto.params.SwRSAPrivateCrtKeyParameters;
import com.sansec.device.SDSFactory;
import com.sansec.device.bean.ExRSArefPrivateKey;
import com.sansec.device.bean.ExRSArefPublicKey;
import com.sansec.device.bean.RSArefPrivateKey;
import com.sansec.device.bean.RSArefPublicKey;
import com.sansec.device.bean.inf.IRSArefPrivateKey;
import com.sansec.device.bean.inf.IRSArefPublicKey;
import com.sansec.device.crypto.ISDSCrypto;
import com.sansec.util.BigIntegers;
import com.sansec.util.Debug;
import java.math.BigInteger;
import java.security.SecureRandom;

public class RSABlindedEngine
implements AsymmetricBlockCipher {
    private static BigInteger ONE = BigInteger.valueOf(1L);
    private RSACoreEngine core = new RSACoreEngine();
    private RSAKeyParameters key;
    private SecureRandom random;

    public void init(boolean forEncryption, CipherParameters param) {
        this.core.init(forEncryption, param);
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.key = (RSAKeyParameters)rParam.getParameters();
            this.random = rParam.getRandom();
        } else {
            this.key = (RSAKeyParameters)param;
            this.random = new SecureRandom();
        }
    }

    public int getInputBlockSize() {
        return this.core.getInputBlockSize();
    }

    public int getOutputBlockSize() {
        return this.core.getOutputBlockSize();
    }

    public byte[] processBlock(byte[] in, int inOff, int inLen) {
        if (this.key == null) {
            throw new IllegalStateException("RSA engine not initialised");
        }
        byte[] out = null;
        int keyIndex = 0;
        if (this.key instanceof SwRSAKeyParams) {
            SwRSAKeyParams keyParam = (SwRSAKeyParams)((Object)this.key);
            keyIndex = keyParam.getKeyIndex();
        }
        byte[] dataInput = in;
        ISDSCrypto device = null;
        try {
            device = SDSFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        if (keyIndex > 0) {
            int keyType = 2;
            if (this.key instanceof SwRSAPrivateCrtKeyParameters) {
                Debug.println(Debug.INFO, "\u5185\u90e8\u79c1\u94a5\u8fd0\u7b97 : KeyIndex " + keyIndex);
                try {
                    dataInput = this.addHeader(dataInput);
                    out = device.rsaPrivateKeyOperation(keyIndex, keyType, dataInput);
                    out = this.removeHeader(out);
                }
                catch (Exception e) {
                    throw new RuntimeCryptoException(e.getMessage());
                }
            }
            Debug.println(Debug.INFO, "\u5185\u90e8\u516c\u94a5\u8fd0\u7b97 : KeyIndex " + keyIndex);
            try {
                dataInput = this.addHeader(dataInput);
                out = device.rsaPublicKeyOperation(keyIndex, keyType, dataInput);
                out = this.removeHeader(out);
            }
            catch (Exception e) {
                throw new RuntimeCryptoException(e.getMessage());
            }
            return out;
        }
        if ((this.key.getModulus().bitLength() + 7) / 8 < 128) {
            BigInteger result;
            Debug.println(Debug.INFO, "\u6a21\u957f\u5c0f\u4e8e1024 \u91c7\u7528\u8f6f\u7b97\u6cd5 : KeyBits " + this.key.getModulus().bitLength());
            BigInteger input = this.core.convertInput(in, inOff, inLen);
            if (this.key instanceof RSAPrivateCrtKeyParameters) {
                RSAPrivateCrtKeyParameters k = (RSAPrivateCrtKeyParameters)this.key;
                BigInteger e = k.getPublicExponent();
                if (e != null) {
                    BigInteger m = k.getModulus();
                    BigInteger r = BigIntegers.createRandomInRange(ONE, m.subtract(ONE), this.random);
                    BigInteger blindedInput = r.modPow(e, m).multiply(input).mod(m);
                    BigInteger blindedResult = this.core.processBlock(blindedInput);
                    BigInteger rInv = r.modInverse(m);
                    result = blindedResult.multiply(rInv).mod(m);
                } else {
                    result = this.core.processBlock(input);
                }
            } else {
                result = this.core.processBlock(input);
            }
            return this.core.convertOutput(result);
        }
        byte[] n = null;
        byte[] e = null;
        byte[] d = null;
        byte[] p1 = null;
        byte[] p2 = null;
        byte[] dp1 = null;
        byte[] dp2 = null;
        byte[] coef = null;
        if (this.key instanceof RSAPrivateCrtKeyParameters) {
            Debug.println(Debug.INFO, "\u5916\u90e8\u79c1\u94a5\u8fd0\u7b97 : KeyBits " + this.key.getModulus().bitLength());
            RSAPrivateCrtKeyParameters k = (RSAPrivateCrtKeyParameters)this.key;
            IRSArefPrivateKey refPrivateKey = null;
            n = BigIntegers.asUnsignedByteArray(k.getModulus());
            e = BigIntegers.asUnsignedByteArray(k.getPublicExponent());
            d = BigIntegers.asUnsignedByteArray(k.getExponent());
            p1 = BigIntegers.asUnsignedByteArray(k.getP());
            p2 = BigIntegers.asUnsignedByteArray(k.getQ());
            dp1 = BigIntegers.asUnsignedByteArray(k.getDP());
            dp2 = BigIntegers.asUnsignedByteArray(k.getDQ());
            coef = BigIntegers.asUnsignedByteArray(k.getQInv());
            refPrivateKey = k.getModulus().bitLength() > 2048 ? new ExRSArefPrivateKey(n, e, d, p1, p2, dp1, dp2, coef) : new RSArefPrivateKey(n, e, d, p1, p2, dp1, dp2, coef);
            try {
                dataInput = this.addHeader(dataInput);
                out = device.rsaPrivateKeyOperation(refPrivateKey, dataInput);
                out = this.removeHeader(out);
            }
            catch (Exception ex) {
                throw new RuntimeCryptoException(ex.getMessage());
            }
        }
        Debug.println(Debug.INFO, "\u5916\u90e8\u516c\u94a5\u8fd0\u7b97 : KeyBits " + this.key.getModulus().bitLength());
        RSAKeyParameters k = this.key;
        IRSArefPublicKey refPublicKey = null;
        n = BigIntegers.asUnsignedByteArray(k.getModulus());
        e = BigIntegers.asUnsignedByteArray(k.getExponent());
        refPublicKey = k.getModulus().bitLength() > 2048 ? new ExRSArefPublicKey(n, e) : new RSArefPublicKey(n, e);
        try {
            dataInput = this.addHeader(dataInput);
            out = device.rsaPublicKeyOperation(refPublicKey, dataInput);
            out = this.removeHeader(out);
        }
        catch (Exception ex) {
            throw new RuntimeCryptoException(ex.getMessage());
        }
        return out;
    }

    private byte[] addHeader(byte[] dataInput) {
        if (dataInput == null) {
            return dataInput;
        }
        if (dataInput.length % 8 == 0) {
            return dataInput;
        }
        byte[] tmp = new byte[dataInput.length + 1];
        tmp[0] = 0;
        System.arraycopy(dataInput, 0, tmp, 1, dataInput.length);
        return tmp;
    }

    private byte[] removeHeader(byte[] dataInput) {
        if (dataInput == null) {
            return null;
        }
        byte type = dataInput[1];
        byte header = dataInput[0];
        if (header == 0 && (type == 1 || type == 2) && dataInput.length % 8 == 0) {
            byte[] tmp = new byte[dataInput.length - 1];
            System.arraycopy(dataInput, 1, tmp, 0, tmp.length);
            return tmp;
        }
        return dataInput;
    }
}

