/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.engines;

import com.sansec.asn1.ASN1InputStream;
import com.sansec.asn1.ASN1Sequence;
import com.sansec.asn1.DERObject;
import com.sansec.asn1.pkcs.SM2CipherStructure;
import com.sansec.asn1.pkcs.SM2StructureUtil;
import com.sansec.crypto.AsymmetricBlockCipher;
import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.crypto.params.ParametersWithRandom;
import com.sansec.crypto.params.SM2PrivateKeyParameters;
import com.sansec.crypto.params.SM2PublicKeyParameters;
import com.sansec.crypto.params.SwSM2KeyParams;
import com.sansec.device.SDSFactory;
import com.sansec.device.bean.SM2refCipher;
import com.sansec.device.bean.SM2refPrivateKey;
import com.sansec.device.bean.SM2refPublicKey;
import com.sansec.device.crypto.ISDSCrypto;
import com.sansec.util.BigIntegerUitl;
import com.sansec.util.Debug;
import com.sansec.util.PrintUtil;

public class SM2EncryptGBEngine
implements AsymmetricBlockCipher {
    private static final int CIPHER_LENGTH = 232;
    private static final int PLAIN_LENGTH = 136;
    private SwSM2KeyParams key;
    private boolean forEncryption;

    public void init(boolean forEncryption, CipherParameters param) {
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.key = (SwSM2KeyParams)((Object)rParam.getParameters());
        } else {
            this.key = (SwSM2KeyParams)((Object)param);
        }
        this.forEncryption = forEncryption;
    }

    public int getInputBlockSize() {
        if (this.forEncryption) {
            return 136;
        }
        return 232;
    }

    public int getOutputBlockSize() {
        if (this.forEncryption) {
            return 232;
        }
        return 136;
    }

    public byte[] processBlock(byte[] in, int inOff, int inLen) {
        if (this.key == null) {
            throw new IllegalStateException("SM2 engine not initialised");
        }
        byte[] out = null;
        int keyIndex = 0;
        byte[] dataInput = in;
        ISDSCrypto device = null;
        try {
            device = SDSFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        int keyType = 2;
        if (this.key instanceof SM2PrivateKeyParameters) {
            SM2PrivateKeyParameters keyParam = (SM2PrivateKeyParameters)this.key;
            keyIndex = keyParam.getKeyIndex();
            ASN1InputStream aIn = new ASN1InputStream(in);
            ASN1Sequence seq = null;
            try {
                DERObject derObj = aIn.readObject();
                seq = (ASN1Sequence)derObj;
            }
            catch (Exception e) {
                throw new RuntimeCryptoException("\u89e3\u6790SM2\u5bc6\u6587\u9519\u8bef \uff1a" + e.getMessage());
            }
            SM2CipherStructure cipherSt = new SM2CipherStructure(seq);
            SM2refCipher cipher = SM2StructureUtil.convert(cipherSt);
            if (keyIndex == 0) {
                byte[] d = BigIntegerUitl.asUnsigned32ByteArray(keyParam.getD());
                SM2refPrivateKey privateKey = new SM2refPrivateKey(d);
                try {
                    out = device.sm2Decrypt(privateKey, cipher);
                }
                catch (Exception e) {
                    Debug.println(Debug.ERROR, "sm2PrivateKeyDecryption error");
                    System.out.println(privateKey);
                    System.out.println(cipher);
                    throw new RuntimeCryptoException(e.getMessage());
                }
            }
            try {
                out = device.sm2Decrypt(keyIndex, keyType, cipher);
            }
            catch (Exception e) {
                Debug.println(Debug.ERROR, "sm2PrivateKeyDecryption error");
                System.out.println(cipher);
                System.out.println("***********************************");
                throw new RuntimeCryptoException(e.getMessage());
            }
            return out;
        }
        SM2PublicKeyParameters keyParam = (SM2PublicKeyParameters)this.key;
        keyIndex = keyParam.getKeyIndex();
        SM2refCipher cipher = null;
        if (keyIndex == 0) {
            byte[] x = BigIntegerUitl.asUnsigned32ByteArray(keyParam.getX());
            byte[] y = BigIntegerUitl.asUnsigned32ByteArray(keyParam.getY());
            SM2refPublicKey publicKey = new SM2refPublicKey(x, y);
            Debug.println(Debug.DEBUG, "public key info");
            try {
                cipher = device.sm2Encrypt(publicKey, dataInput);
            }
            catch (Exception e) {
                Debug.println(Debug.ERROR, "sm2PublicKeyEncryption error");
                System.err.println("data input");
                System.err.println(PrintUtil.toHexString(dataInput));
                System.err.println(publicKey);
                System.err.println(cipher);
                System.out.println("***********************************");
                throw new RuntimeCryptoException(e.getMessage());
            }
        }
        try {
            cipher = device.sm2Encrypt(keyIndex, keyType, in);
        }
        catch (Exception e) {
            Debug.println(Debug.ERROR, "sm2PublicKeyEncryption error");
            System.err.println("data input");
            System.err.println(PrintUtil.toHexString(in));
            System.out.println("***********************************");
            throw new RuntimeCryptoException(e.getMessage());
        }
        Debug.println(Debug.DEBUG, "cipher info");
        SM2CipherStructure cipherSt = SM2StructureUtil.convert(cipher);
        out = cipherSt.getDEREncoded();
        return out;
    }
}

