/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.engines;

import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.crypto.params.ParametersWithRandom;
import com.sansec.crypto.params.SM2PrivateKeyParameters;
import com.sansec.crypto.params.SM2PublicKeyParameters;
import com.sansec.crypto.params.SwSM2KeyParams;
import com.sansec.device.SDSFactory;
import com.sansec.device.bean.SM2refPrivateKey;
import com.sansec.device.bean.SM2refPublicKey;
import com.sansec.device.bean.SM2refSignature;
import com.sansec.device.crypto.ISDSCrypto;
import com.sansec.util.BigIntegerUitl;
import com.sansec.util.Debug;
import com.sansec.util.PrintUtil;

public class SM2SignEngine {
    private static final int SIGNATURE_LENGTH = 247;
    private SwSM2KeyParams key;
    private boolean forSign;

    public void init(boolean forSign, CipherParameters param) {
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.key = (SwSM2KeyParams)((Object)rParam.getParameters());
        } else {
            this.key = (SwSM2KeyParams)((Object)param);
        }
        this.forSign = forSign;
    }

    public int getInputBlockSize() {
        if (this.forSign) {
            return this.key.getBits() / 8;
        }
        return 247;
    }

    public int getOutputBlockSize() {
        if (this.forSign) {
            return 247;
        }
        return 1;
    }

    public byte[] sign(byte[] in, int inOff, int inLen) {
        if (this.key == null) {
            throw new IllegalStateException("SM2 sign engine not initialised");
        }
        SM2refSignature signature = null;
        int keyIndex = 0;
        byte[] dataInput = in;
        ISDSCrypto device = null;
        try {
            device = SDSFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        SM2PrivateKeyParameters keyParam = (SM2PrivateKeyParameters)this.key;
        keyIndex = keyParam.getKeyIndex();
        if (keyIndex == 0) {
            byte[] d = BigIntegerUitl.asUnsigned32ByteArray(keyParam.getD());
            SM2refPrivateKey privateKey = new SM2refPrivateKey(d);
            Debug.println(Debug.DEBUG, "private key info");
            try {
                signature = device.sm2Sign(privateKey, dataInput);
            }
            catch (Exception e) {
                Debug.println(Debug.ERROR, "sm2Sign error");
                System.err.println(privateKey);
                System.err.println("data input");
                System.err.println(PrintUtil.toHexString(dataInput));
                throw new RuntimeCryptoException(e.getMessage());
            }
        }
        try {
            signature = device.sm2Sign(keyIndex, dataInput);
        }
        catch (Exception e) {
            Debug.println(Debug.ERROR, "sm2Sign error");
            System.err.println("keyIndex = " + keyIndex);
            System.err.println("data input");
            System.err.println(PrintUtil.toHexString(dataInput));
            throw new RuntimeCryptoException(e.getMessage());
        }
        Debug.println(Debug.DEBUG, "sign signature value info");
        byte[] buffer = new byte[64];
        System.arraycopy(signature.getR(), 0, buffer, 0, 32);
        System.arraycopy(signature.getS(), 0, buffer, 32, 32);
        return buffer;
    }

    public boolean veryfiy(byte[] in, int inOff, int inLen, byte[] sigBytes, int sigOff, int sigLen) {
        boolean flag;
        if (this.key == null) {
            throw new IllegalStateException("SM2 sign engine not initialised");
        }
        int keyIndex = 0;
        byte[] dataInput = in;
        ISDSCrypto device = null;
        try {
            device = SDSFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        SM2PublicKeyParameters keyParam = (SM2PublicKeyParameters)this.key;
        keyIndex = keyParam.getKeyIndex();
        byte[] r = new byte[32];
        System.arraycopy(sigBytes, 0, r, 0, 32);
        byte[] s = new byte[32];
        System.arraycopy(sigBytes, 32, s, 0, 32);
        SM2refSignature signature = new SM2refSignature(r, s);
        if (keyIndex == 0) {
            byte[] x = BigIntegerUitl.asUnsigned32ByteArray(keyParam.getX());
            byte[] y = BigIntegerUitl.asUnsigned32ByteArray(keyParam.getY());
            SM2refPublicKey publicKey = new SM2refPublicKey(x, y);
            Debug.println(Debug.DEBUG, "public key info");
            try {
                flag = device.sm2Verify(publicKey, dataInput, signature);
            }
            catch (Exception e) {
                throw new RuntimeCryptoException(e.getMessage());
            }
        }
        try {
            flag = device.sm2Verify(keyIndex, dataInput, signature);
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        return flag;
    }
}

