/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.generators;

import com.sansec.crypto.CipherKeyGenerator;
import com.sansec.crypto.KeyGenerationParameters;
import com.sansec.crypto.params.DESParameters;

public class DESKeyGenerator
extends CipherKeyGenerator {
    public void init(KeyGenerationParameters param) {
        super.init(param);
        if (this.strength == 0 || this.strength == 7) {
            this.strength = 8;
        } else if (this.strength != 8) {
            throw new IllegalArgumentException("DES key must be 64 bits long.");
        }
    }

    public byte[] generateKey() {
        byte[] newKey = new byte[8];
        do {
            this.random.nextBytes(newKey);
            DESParameters.setOddParity(newKey);
        } while (DESParameters.isWeakKey(newKey, 0));
        return newKey;
    }
}

