/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.generators;

import com.sansec.crypto.KeyGenerationParameters;
import com.sansec.crypto.generators.DESKeyGenerator;
import java.util.Arrays;

public class DESedeKeyGenerator
extends DESKeyGenerator {
    public void init(KeyGenerationParameters param) {
        this.random = param.getRandom();
        this.strength = param.getStrength();
        if (this.strength != 64 && this.strength != 128 && this.strength != 192 && (this.strength < 65536 || this.strength > 0x640000)) {
            throw new IllegalArgumentException("3DES key must be 64/128/192 bits long or internal key.Length: " + this.strength);
        }
    }

    public byte[] generateKey() {
        byte[] newKey = new byte[16];
        if (this.strength < 65536) {
            boolean flag = true;
            byte[] head = new byte[this.strength / 8 - 1];
            do {
                this.random.nextBytes(newKey);
                byte[] tmp = new byte[head.length];
                System.arraycopy(newKey, 0, tmp, 0, tmp.length);
                if (Arrays.equals(head, tmp)) continue;
                flag = false;
            } while (flag);
        } else {
            newKey[15] = (byte)(this.strength >> 16);
        }
        return newKey;
    }
}

