/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.generators;

import com.sansec.crypto.AsymmetricCipherKeyPair;
import com.sansec.crypto.AsymmetricCipherKeyPairGenerator;
import com.sansec.crypto.KeyGenerationParameters;
import com.sansec.crypto.params.DSAKeyGenerationParameters;
import com.sansec.crypto.params.DSAParameters;
import com.sansec.crypto.params.DSAPrivateKeyParameters;
import com.sansec.crypto.params.DSAPublicKeyParameters;
import com.sansec.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private DSAKeyGenerationParameters param;

    public void init(KeyGenerationParameters param) {
        this.param = (DSAKeyGenerationParameters)param;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DSAParameters dsaParams = this.param.getParameters();
        BigInteger x = DSAKeyPairGenerator.generatePrivateKey(dsaParams.getQ(), this.param.getRandom());
        BigInteger y = DSAKeyPairGenerator.calculatePublicKey(dsaParams.getP(), dsaParams.getG(), x);
        return new AsymmetricCipherKeyPair(new DSAPublicKeyParameters(y, dsaParams), new DSAPrivateKeyParameters(x, dsaParams));
    }

    private static BigInteger generatePrivateKey(BigInteger q, SecureRandom random) {
        return BigIntegers.createRandomInRange(ONE, q.subtract(ONE), random);
    }

    private static BigInteger calculatePublicKey(BigInteger p, BigInteger g, BigInteger x) {
        return g.modPow(x, p);
    }
}

