/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.generators;

import com.sansec.crypto.AsymmetricCipherKeyPair;
import com.sansec.crypto.AsymmetricCipherKeyPairGenerator;
import com.sansec.crypto.KeyGenerationParameters;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.crypto.params.SM2KeyGenerationParameters;
import com.sansec.crypto.params.SM2PrivateKeyParameters;
import com.sansec.crypto.params.SM2PublicKeyParameters;
import com.sansec.device.SDSFactory;
import com.sansec.device.bean.SM2refKeyPair;
import com.sansec.device.bean.SM2refPrivateKey;
import com.sansec.device.bean.SM2refPublicKey;
import com.sansec.device.crypto.ISDSCrypto;
import com.sansec.util.BigIntegerUitl;
import com.sansec.util.Debug;
import java.math.BigInteger;

public class SM2KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SM2KeyGenerationParameters param;

    public AsymmetricCipherKeyPair generateKeyPair() {
        int strength = this.param.getStrength();
        ISDSCrypto device = null;
        try {
            device = SDSFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        if (strength >= 65536) {
            int bits;
            int keyType = 2;
            int keyIndex = strength >> 16;
            Debug.println(Debug.DEBUG, "\u751f\u6210\u5185\u90e8\u5bc6\u94a5 : KeyIndex " + keyIndex);
            BigInteger x = null;
            BigInteger y = null;
            try {
                SM2refPublicKey publicKey = device.getSM2PublicKey(keyIndex, keyType);
                bits = publicKey.getBits();
                x = BigIntegerUitl.toPositiveInteger(publicKey.getX());
                y = BigIntegerUitl.toPositiveInteger(publicKey.getY());
            }
            catch (Exception ex) {
                throw new RuntimeCryptoException(ex.getMessage());
            }
            BigInteger d = null;
            d = new BigInteger(String.valueOf(keyIndex));
            return new AsymmetricCipherKeyPair(new SM2PublicKeyParameters(keyIndex, bits, x, y), new SM2PrivateKeyParameters(keyIndex, bits, d));
        }
        SM2refKeyPair keyPair = null;
        try {
            keyPair = device.generateSM2KeyPair(strength);
        }
        catch (Exception e) {
            throw new RuntimeCryptoException(e.getMessage());
        }
        BigInteger d = null;
        BigInteger x = null;
        BigInteger y = null;
        SM2refPrivateKey privateKey = keyPair.getPrivateKey();
        d = BigIntegerUitl.toPositiveInteger(privateKey.getD());
        SM2refPublicKey publicKey = keyPair.getPublicKey();
        x = BigIntegerUitl.toPositiveInteger(publicKey.getX());
        y = BigIntegerUitl.toPositiveInteger(publicKey.getY());
        int bits = publicKey.getBits();
        Debug.println(Debug.DEBUG, "\u751f\u6210\u5916\u90e8\u5bc6\u94a5 : KeyBits " + strength);
        return new AsymmetricCipherKeyPair(new SM2PublicKeyParameters(0, bits, x, y), new SM2PrivateKeyParameters(0, bits, d));
    }

    public void init(KeyGenerationParameters param) {
        this.param = (SM2KeyGenerationParameters)param;
    }
}

