/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.generators;

import com.sansec.crypto.AsymmetricCipherKeyPair;
import com.sansec.crypto.KeyGenerationParameters;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.crypto.generators.RSAKeyPairGenerator;
import com.sansec.crypto.params.RSAKeyGenerationParameters;
import com.sansec.crypto.params.SwRSAKeyParameters;
import com.sansec.crypto.params.SwRSAPrivateCrtKeyParameters;
import com.sansec.device.SDSFactory;
import com.sansec.device.bean.RSArefKeyPair;
import com.sansec.device.bean.inf.IRSArefPrivateKey;
import com.sansec.device.bean.inf.IRSArefPublicKey;
import com.sansec.device.crypto.ISDSCrypto;
import com.sansec.util.BigIntegerUitl;
import com.sansec.util.Debug;
import java.math.BigInteger;

public class SwRSAKeyPairGenerator
extends RSAKeyPairGenerator {
    private RSAKeyGenerationParameters param;

    public AsymmetricCipherKeyPair generateKeyPair() {
        int strength = this.param.getStrength();
        ISDSCrypto device = null;
        try {
            device = SDSFactory.getInstance();
        }
        catch (Exception ex) {
            throw new RuntimeCryptoException(ex.getMessage());
        }
        BigInteger e = null;
        BigInteger n = null;
        BigInteger d = null;
        BigInteger p1 = null;
        BigInteger p2 = null;
        BigInteger dp1 = null;
        BigInteger dp2 = null;
        BigInteger coef = null;
        if (strength >= 65536) {
            int kpType = 2;
            int keyIndex = strength >> 16;
            Debug.println(Debug.INFO, "\u751f\u6210\u5185\u90e8\u5bc6\u94a5 : KeyIndex " + keyIndex);
            try {
                IRSArefPublicKey publicKey = device.getRSAPublicKey(keyIndex, kpType);
                e = BigIntegerUitl.toPositiveInteger(publicKey.getE());
                n = BigIntegerUitl.toPositiveInteger(publicKey.getN());
            }
            catch (Exception ex) {
                throw new RuntimeCryptoException(ex.getMessage());
            }
            d = new BigInteger(String.valueOf(keyIndex));
            p1 = new BigInteger("233563654cf386303bf992e36d247c426a49582bce1176ef0141e07ca5cebe36f1bfd17168d93bebe4f793f138426f25271111bbbde41b26ae5b0e08ad34e29d".getBytes());
            p2 = new BigInteger("2efc3edef58e42763465786a4249c9ed74edf7121cb76198c840f5c47f60ce5e420ef1a99e6ca5eaa643059dec32db231225e58aafeaaf00972ddbbee0799ed9".getBytes());
            dp1 = new BigInteger("567770b31f3ca54498ce0e4f150a97b2f51ec65e2c9140fb9032dfa0f14223965d34993dfcccdee4eb2eaa46647e1a0dd769d6282d46dff04ca4cac482effe71".getBytes());
            dp2 = new BigInteger("2a56191b994dacb8a275c2e594d14f1cda5e3955324f2d8fcdca7ab5d093108961e7fbe304e44eb8f838b247f37aaf6f343169974e6a8b1277b6b3867f2744d9".getBytes());
            coef = new BigInteger("750602341519eb77e4311c9e91a31c5677d3b6e88d8be594436b110573afc8a5e4e4957495ad88624958ff732f97f0d71a37cd64abbf260ff9907a0c68c027f4".getBytes());
            return new AsymmetricCipherKeyPair(new SwRSAKeyParameters(keyIndex, false, n, e), new SwRSAPrivateCrtKeyParameters(keyIndex, n, e, d, p1, p2, dp1, dp2, coef));
        }
        boolean isFilter = true;
        boolean isOk = false;
        IRSArefPrivateKey refPrivateKey = null;
        int i = 0;
        while (!isOk) {
            RSArefKeyPair keyPair = null;
            try {
                keyPair = device.generateRSAKeyPair(strength);
            }
            catch (Exception ex) {
                throw new RuntimeCryptoException(ex.getMessage());
            }
            Debug.println(Debug.INFO, "\u751f\u6210\u5916\u90e8\u5bc6\u94a5 : KeyBits " + strength);
            refPrivateKey = keyPair.getPrivateKey();
            int bits = refPrivateKey.getBits();
            int header = 0;
            header = bits >= 1024 && bits <= 2048 ? (2048 - bits) / 8 : (4096 - bits) / 8;
            byte[] nb = refPrivateKey.getN();
            isOk = !isFilter || nb[header + 0] != 0 || nb[header + 1] < 0;
            ++i;
        }
        n = new BigInteger(1, refPrivateKey.getN());
        e = new BigInteger(1, refPrivateKey.getE());
        d = new BigInteger(1, refPrivateKey.getD());
        p1 = new BigInteger(1, refPrivateKey.getPrime1());
        p2 = new BigInteger(1, refPrivateKey.getPrime2());
        dp1 = new BigInteger(1, refPrivateKey.getDPrime1());
        dp2 = new BigInteger(1, refPrivateKey.getDPrime2());
        coef = new BigInteger(1, refPrivateKey.getCoef());
        return new AsymmetricCipherKeyPair(new SwRSAKeyParameters(0, false, n, e), new SwRSAPrivateCrtKeyParameters(0, n, e, d, p1, p2, dp1, dp2, coef));
    }

    public void init(KeyGenerationParameters param) {
        super.init(param);
        this.param = (RSAKeyGenerationParameters)param;
    }
}

