/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.modes;

import com.sansec.crypto.BlockCipher;
import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.DataLengthException;
import com.sansec.crypto.InvalidCipherTextException;
import com.sansec.crypto.macs.CBCBlockCipherMac;
import com.sansec.crypto.modes.AEADBlockCipher;
import com.sansec.crypto.modes.SICBlockCipher;
import com.sansec.crypto.params.AEADParameters;
import com.sansec.crypto.params.ParametersWithIV;
import com.sansec.util.Arrays;
import java.io.ByteArrayOutputStream;

public class CCMBlockCipher
implements AEADBlockCipher {
    private BlockCipher cipher;
    private int blockSize;
    private boolean forEncryption;
    private byte[] nonce;
    private byte[] associatedText;
    private int macSize;
    private CipherParameters keyParam;
    private byte[] macBlock;
    private ByteArrayOutputStream data = new ByteArrayOutputStream();

    public CCMBlockCipher(BlockCipher c) {
        this.cipher = c;
        this.blockSize = c.getBlockSize();
        this.macBlock = new byte[this.blockSize];
        if (this.blockSize != 16) {
            throw new IllegalArgumentException("cipher required with a block size of 16.");
        }
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        this.forEncryption = forEncryption;
        if (params instanceof AEADParameters) {
            AEADParameters param = (AEADParameters)params;
            this.nonce = param.getNonce();
            this.associatedText = param.getAssociatedText();
            this.macSize = param.getMacSize() / 8;
            this.keyParam = param.getKey();
        } else if (params instanceof ParametersWithIV) {
            ParametersWithIV param = (ParametersWithIV)params;
            this.nonce = param.getIV();
            this.associatedText = null;
            this.macSize = this.macBlock.length / 2;
            this.keyParam = param.getParameters();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to CCM");
        }
    }

    public String getAlgorithmName() {
        return String.valueOf(this.cipher.getAlgorithmName()) + "/CCM";
    }

    public int processByte(byte in, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        this.data.write(in);
        return 0;
    }

    public int processBytes(byte[] in, int inOff, int inLen, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        this.data.write(in, inOff, inLen);
        return 0;
    }

    public int doFinal(byte[] out, int outOff) throws IllegalStateException, InvalidCipherTextException {
        byte[] text = this.data.toByteArray();
        byte[] enc = this.processPacket(text, 0, text.length);
        System.arraycopy(enc, 0, out, outOff, enc.length);
        this.reset();
        return enc.length;
    }

    public void reset() {
        this.cipher.reset();
        this.data.reset();
    }

    public byte[] getMac() {
        byte[] mac = new byte[this.macSize];
        System.arraycopy(this.macBlock, 0, mac, 0, mac.length);
        return mac;
    }

    public int getUpdateOutputSize(int len) {
        return 0;
    }

    public int getOutputSize(int len) {
        if (this.forEncryption) {
            return this.data.size() + len + this.macSize;
        }
        return this.data.size() + len - this.macSize;
    }

    public byte[] processPacket(byte[] in, int inOff, int inLen) throws IllegalStateException, InvalidCipherTextException {
        byte[] out;
        if (this.keyParam == null) {
            throw new IllegalStateException("CCM cipher unitialized.");
        }
        SICBlockCipher ctrCipher = new SICBlockCipher(this.cipher);
        byte[] iv = new byte[this.blockSize];
        iv[0] = (byte)(15 - this.nonce.length - 1 & 7);
        System.arraycopy(this.nonce, 0, iv, 1, this.nonce.length);
        ctrCipher.init(this.forEncryption, new ParametersWithIV(this.keyParam, iv));
        if (this.forEncryption) {
            int index = inOff;
            int outOff = 0;
            out = new byte[inLen + this.macSize];
            this.calculateMac(in, inOff, inLen, this.macBlock);
            ctrCipher.processBlock(this.macBlock, 0, this.macBlock, 0);
            while (index < inLen - this.blockSize) {
                ctrCipher.processBlock(in, index, out, outOff);
                outOff += this.blockSize;
                index += this.blockSize;
            }
            byte[] block = new byte[this.blockSize];
            System.arraycopy(in, index, block, 0, inLen - index);
            ctrCipher.processBlock(block, 0, block, 0);
            System.arraycopy(block, 0, out, outOff, inLen - index);
            System.arraycopy(this.macBlock, 0, out, outOff += inLen - index, out.length - outOff);
        } else {
            int index = inOff;
            int outOff = 0;
            out = new byte[inLen - this.macSize];
            System.arraycopy(in, inOff + inLen - this.macSize, this.macBlock, 0, this.macSize);
            ctrCipher.processBlock(this.macBlock, 0, this.macBlock, 0);
            int i = this.macSize;
            while (i != this.macBlock.length) {
                this.macBlock[i] = 0;
                ++i;
            }
            while (outOff < out.length - this.blockSize) {
                ctrCipher.processBlock(in, index, out, outOff);
                outOff += this.blockSize;
                index += this.blockSize;
            }
            byte[] block = new byte[this.blockSize];
            System.arraycopy(in, index, block, 0, out.length - outOff);
            ctrCipher.processBlock(block, 0, block, 0);
            System.arraycopy(block, 0, out, outOff, out.length - outOff);
            byte[] calculatedMacBlock = new byte[this.blockSize];
            this.calculateMac(out, 0, out.length, calculatedMacBlock);
            if (!Arrays.constantTimeAreEqual(this.macBlock, calculatedMacBlock)) {
                throw new InvalidCipherTextException("mac check in CCM failed");
            }
        }
        return out;
    }

    private int calculateMac(byte[] data, int dataOff, int dataLen, byte[] macBlock) {
        CBCBlockCipherMac cMac = new CBCBlockCipherMac(this.cipher, this.macSize * 8);
        cMac.init(this.keyParam);
        byte[] b0 = new byte[16];
        if (this.hasAssociatedText()) {
            b0[0] = (byte)(b0[0] | 0x40);
        }
        b0[0] = (byte)(b0[0] | ((cMac.getMacSize() - 2) / 2 & 7) << 3);
        b0[0] = (byte)(b0[0] | 15 - this.nonce.length - 1 & 7);
        System.arraycopy(this.nonce, 0, b0, 1, this.nonce.length);
        int q = dataLen;
        int count = 1;
        while (q > 0) {
            b0[b0.length - count] = (byte)(q & 0xFF);
            q >>>= 8;
            ++count;
        }
        cMac.update(b0, 0, b0.length);
        if (this.hasAssociatedText()) {
            int extra;
            if (this.associatedText.length < 65280) {
                cMac.update((byte)(this.associatedText.length >> 8));
                cMac.update((byte)this.associatedText.length);
                extra = 2;
            } else {
                cMac.update((byte)-1);
                cMac.update((byte)-2);
                cMac.update((byte)(this.associatedText.length >> 24));
                cMac.update((byte)(this.associatedText.length >> 16));
                cMac.update((byte)(this.associatedText.length >> 8));
                cMac.update((byte)this.associatedText.length);
                extra = 6;
            }
            cMac.update(this.associatedText, 0, this.associatedText.length);
            extra = (extra + this.associatedText.length) % 16;
            if (extra != 0) {
                int i = 0;
                while (i != 16 - extra) {
                    cMac.update((byte)0);
                    ++i;
                }
            }
        }
        cMac.update(data, dataOff, dataLen);
        return cMac.doFinal(macBlock, 0);
    }

    private boolean hasAssociatedText() {
        return this.associatedText != null && this.associatedText.length != 0;
    }
}

