/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.modes.gcm;

import com.sansec.crypto.modes.gcm.GCMMultiplier;
import com.sansec.crypto.modes.gcm.GCMUtil;
import com.sansec.util.Arrays;

public class BasicGCMMultiplier
implements GCMMultiplier {
    private byte[] H;

    public void init(byte[] H) {
        this.H = Arrays.clone(H);
    }

    public void multiplyH(byte[] x) {
        byte[] z = new byte[16];
        int i = 0;
        while (i < 16) {
            byte h = this.H[i];
            int j = 7;
            while (j >= 0) {
                if ((h & 1 << j) != 0) {
                    GCMUtil.xor(z, x);
                }
                boolean lsb = (x[15] & 1) != 0;
                GCMUtil.shiftRight(x);
                if (lsb) {
                    x[0] = (byte)(x[0] ^ 0xFFFFFFE1);
                }
                --j;
            }
            ++i;
        }
        System.arraycopy(z, 0, x, 0, 16);
    }
}

