/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.tls;

import com.sansec.crypto.digests.SHA1Digest;
import com.sansec.crypto.engines.AESFastEngine;
import com.sansec.crypto.engines.DESedeEngine;
import com.sansec.crypto.modes.CBCBlockCipher;
import com.sansec.crypto.tls.TlsBlockCipherCipherSuite;
import com.sansec.crypto.tls.TlsCipherSuite;
import com.sansec.crypto.tls.TlsProtocolHandler;
import com.sansec.crypto.tls.TlsUtils;
import java.io.IOException;
import java.io.OutputStream;

public class TlsCipherSuiteManager {
    private static final int TLS_RSA_WITH_3DES_EDE_CBC_SHA = 10;
    private static final int TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA = 19;
    private static final int TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA = 22;
    private static final int TLS_RSA_WITH_AES_128_CBC_SHA = 47;
    private static final int TLS_DHE_DSS_WITH_AES_128_CBC_SHA = 50;
    private static final int TLS_DHE_RSA_WITH_AES_128_CBC_SHA = 51;
    private static final int TLS_RSA_WITH_AES_256_CBC_SHA = 53;
    private static final int TLS_DHE_DSS_WITH_AES_256_CBC_SHA = 56;
    private static final int TLS_DHE_RSA_WITH_AES_256_CBC_SHA = 57;

    protected static void writeCipherSuites(OutputStream os) throws IOException {
        int[] suites = new int[]{57, 56, 51, 50, 22, 19, 53, 47, 10};
        TlsUtils.writeUint16(2 * suites.length, os);
        int i = 0;
        while (i < suites.length) {
            TlsUtils.writeUint16(suites[i], os);
            ++i;
        }
    }

    protected static TlsCipherSuite getCipherSuite(int number, TlsProtocolHandler handler) throws IOException {
        switch (number) {
            case 10: {
                return TlsCipherSuiteManager.createDESedeCipherSuite(24, (short)1);
            }
            case 19: {
                return TlsCipherSuiteManager.createDESedeCipherSuite(24, (short)3);
            }
            case 22: {
                return TlsCipherSuiteManager.createDESedeCipherSuite(24, (short)5);
            }
            case 47: {
                return TlsCipherSuiteManager.createAESCipherSuite(16, (short)1);
            }
            case 50: {
                return TlsCipherSuiteManager.createAESCipherSuite(16, (short)3);
            }
            case 51: {
                return TlsCipherSuiteManager.createAESCipherSuite(16, (short)5);
            }
            case 53: {
                return TlsCipherSuiteManager.createAESCipherSuite(32, (short)1);
            }
            case 56: {
                return TlsCipherSuiteManager.createAESCipherSuite(32, (short)3);
            }
            case 57: {
                return TlsCipherSuiteManager.createAESCipherSuite(32, (short)5);
            }
        }
        handler.failWithError((short)2, (short)40);
        return null;
    }

    private static TlsCipherSuite createAESCipherSuite(int cipherKeySize, short keyExchange) {
        return new TlsBlockCipherCipherSuite(TlsCipherSuiteManager.createAESCipher(), TlsCipherSuiteManager.createAESCipher(), new SHA1Digest(), new SHA1Digest(), cipherKeySize, keyExchange);
    }

    private static TlsCipherSuite createDESedeCipherSuite(int cipherKeySize, short keyExchange) {
        return new TlsBlockCipherCipherSuite(TlsCipherSuiteManager.createDESedeCipher(), TlsCipherSuiteManager.createDESedeCipher(), new SHA1Digest(), new SHA1Digest(), cipherKeySize, keyExchange);
    }

    private static CBCBlockCipher createAESCipher() {
        return new CBCBlockCipher(new AESFastEngine());
    }

    private static CBCBlockCipher createDESedeCipher() {
        return new CBCBlockCipher(new DESedeEngine());
    }
}

