/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.tls;

import com.sansec.asn1.DERBitString;
import com.sansec.asn1.x509.KeyUsage;
import com.sansec.asn1.x509.SubjectPublicKeyInfo;
import com.sansec.asn1.x509.X509CertificateStructure;
import com.sansec.asn1.x509.X509Extension;
import com.sansec.asn1.x509.X509Extensions;
import com.sansec.crypto.AsymmetricCipherKeyPair;
import com.sansec.crypto.CryptoException;
import com.sansec.crypto.InvalidCipherTextException;
import com.sansec.crypto.Signer;
import com.sansec.crypto.agreement.DHBasicAgreement;
import com.sansec.crypto.agreement.srp.SRP6Client;
import com.sansec.crypto.digests.SHA1Digest;
import com.sansec.crypto.encodings.PKCS1Encoding;
import com.sansec.crypto.engines.RSABlindedEngine;
import com.sansec.crypto.generators.DHBasicKeyPairGenerator;
import com.sansec.crypto.io.SignerInputStream;
import com.sansec.crypto.params.AsymmetricKeyParameter;
import com.sansec.crypto.params.DHKeyGenerationParameters;
import com.sansec.crypto.params.DHParameters;
import com.sansec.crypto.params.DHPublicKeyParameters;
import com.sansec.crypto.params.DSAPublicKeyParameters;
import com.sansec.crypto.params.ParametersWithRandom;
import com.sansec.crypto.params.RSAKeyParameters;
import com.sansec.crypto.prng.ThreadedSeedGenerator;
import com.sansec.crypto.tls.ByteQueue;
import com.sansec.crypto.tls.Certificate;
import com.sansec.crypto.tls.CertificateVerifyer;
import com.sansec.crypto.tls.RecordStream;
import com.sansec.crypto.tls.TlsCipherSuite;
import com.sansec.crypto.tls.TlsCipherSuiteManager;
import com.sansec.crypto.tls.TlsDSSSigner;
import com.sansec.crypto.tls.TlsInputStream;
import com.sansec.crypto.tls.TlsOuputStream;
import com.sansec.crypto.tls.TlsRSASigner;
import com.sansec.crypto.tls.TlsUtils;
import com.sansec.crypto.util.PublicKeyFactory;
import com.sansec.util.BigIntegers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Hashtable;

public class TlsProtocolHandler {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final short RL_CHANGE_CIPHER_SPEC = 20;
    private static final short RL_ALERT = 21;
    private static final short RL_HANDSHAKE = 22;
    private static final short RL_APPLICATION_DATA = 23;
    private static final short HP_HELLO_REQUEST = 0;
    private static final short HP_CLIENT_HELLO = 1;
    private static final short HP_SERVER_HELLO = 2;
    private static final short HP_CERTIFICATE = 11;
    private static final short HP_SERVER_KEY_EXCHANGE = 12;
    private static final short HP_CERTIFICATE_REQUEST = 13;
    private static final short HP_SERVER_HELLO_DONE = 14;
    private static final short HP_CERTIFICATE_VERIFY = 15;
    private static final short HP_CLIENT_KEY_EXCHANGE = 16;
    private static final short HP_FINISHED = 20;
    private static final short CS_CLIENT_HELLO_SEND = 1;
    private static final short CS_SERVER_HELLO_RECEIVED = 2;
    private static final short CS_SERVER_CERTIFICATE_RECEIVED = 3;
    private static final short CS_SERVER_KEY_EXCHANGE_RECEIVED = 4;
    private static final short CS_CERTIFICATE_REQUEST_RECEIVED = 5;
    private static final short CS_SERVER_HELLO_DONE_RECEIVED = 6;
    private static final short CS_CLIENT_KEY_EXCHANGE_SEND = 7;
    private static final short CS_CLIENT_VERIFICATION_SEND = 8;
    private static final short CS_CLIENT_CHANGE_CIPHER_SPEC_SEND = 9;
    private static final short CS_CLIENT_FINISHED_SEND = 10;
    private static final short CS_SERVER_CHANGE_CIPHER_SPEC_RECEIVED = 11;
    private static final short CS_DONE = 12;
    protected static final short AP_close_notify = 0;
    protected static final short AP_unexpected_message = 10;
    protected static final short AP_bad_record_mac = 20;
    protected static final short AP_decryption_failed = 21;
    protected static final short AP_record_overflow = 22;
    protected static final short AP_decompression_failure = 30;
    protected static final short AP_handshake_failure = 40;
    protected static final short AP_bad_certificate = 42;
    protected static final short AP_unsupported_certificate = 43;
    protected static final short AP_certificate_revoked = 44;
    protected static final short AP_certificate_expired = 45;
    protected static final short AP_certificate_unknown = 46;
    protected static final short AP_illegal_parameter = 47;
    protected static final short AP_unknown_ca = 48;
    protected static final short AP_access_denied = 49;
    protected static final short AP_decode_error = 50;
    protected static final short AP_decrypt_error = 51;
    protected static final short AP_export_restriction = 60;
    protected static final short AP_protocol_version = 70;
    protected static final short AP_insufficient_security = 71;
    protected static final short AP_internal_error = 80;
    protected static final short AP_user_canceled = 90;
    protected static final short AP_no_renegotiation = 100;
    protected static final short AL_warning = 1;
    protected static final short AL_fatal = 2;
    private static final byte[] emptybuf = new byte[0];
    private static final String TLS_ERROR_MESSAGE = "Internal TLS error, this could be an attack";
    private ByteQueue applicationDataQueue = new ByteQueue();
    private ByteQueue changeCipherSpecQueue = new ByteQueue();
    private ByteQueue alertQueue = new ByteQueue();
    private ByteQueue handshakeQueue = new ByteQueue();
    private RecordStream rs;
    private SecureRandom random;
    private AsymmetricKeyParameter serverPublicKey = null;
    private TlsInputStream tlsInputStream = null;
    private TlsOuputStream tlsOutputStream = null;
    private boolean closed = false;
    private boolean failedWithError = false;
    private boolean appDataReady = false;
    private boolean extendedClientHello;
    private byte[] clientRandom;
    private byte[] serverRandom;
    private byte[] ms;
    private TlsCipherSuite chosenCipherSuite = null;
    private BigInteger SRP_A;
    private byte[] SRP_identity;
    private byte[] SRP_password;
    private BigInteger Yc;
    private byte[] pms;
    private CertificateVerifyer verifyer = null;
    private short connection_state;

    public TlsProtocolHandler(InputStream is, OutputStream os) {
        ThreadedSeedGenerator tsg = new ThreadedSeedGenerator();
        this.random = new SecureRandom();
        this.random.setSeed(tsg.generateSeed(20, true));
        this.rs = new RecordStream(this, is, os);
    }

    public TlsProtocolHandler(InputStream is, OutputStream os, SecureRandom sr) {
        this.random = sr;
        this.rs = new RecordStream(this, is, os);
    }

    protected void processData(short protocol, byte[] buf, int offset, int len) throws IOException {
        switch (protocol) {
            case 20: {
                this.changeCipherSpecQueue.addData(buf, offset, len);
                this.processChangeCipherSpec();
                break;
            }
            case 21: {
                this.alertQueue.addData(buf, offset, len);
                this.processAlert();
                break;
            }
            case 22: {
                this.handshakeQueue.addData(buf, offset, len);
                this.processHandshake();
                break;
            }
            case 23: {
                if (!this.appDataReady) {
                    this.failWithError((short)2, (short)10);
                }
                this.applicationDataQueue.addData(buf, offset, len);
                this.processApplicationData();
            }
        }
    }

    private void processHandshake() throws IOException {
        boolean read;
        do {
            read = false;
            if (this.handshakeQueue.size() < 4) continue;
            byte[] beginning = new byte[4];
            this.handshakeQueue.read(beginning, 0, 4, 0);
            ByteArrayInputStream bis = new ByteArrayInputStream(beginning);
            short type = TlsUtils.readUint8(bis);
            int len = TlsUtils.readUint24(bis);
            if (this.handshakeQueue.size() < len + 4) continue;
            byte[] buf = new byte[len];
            this.handshakeQueue.read(buf, 0, len, 4);
            this.handshakeQueue.removeData(len + 4);
            if (type != 20) {
                this.rs.hash1.update(beginning, 0, 4);
                this.rs.hash2.update(beginning, 0, 4);
                this.rs.hash1.update(buf, 0, len);
                this.rs.hash2.update(buf, 0, len);
            }
            ByteArrayInputStream is = new ByteArrayInputStream(buf);
            block2 : switch (type) {
                case 11: {
                    switch (this.connection_state) {
                        case 2: {
                            Certificate cert = Certificate.parse(is);
                            this.assertEmpty(is);
                            X509CertificateStructure x509Cert = cert.certs[0];
                            SubjectPublicKeyInfo keyInfo = x509Cert.getSubjectPublicKeyInfo();
                            try {
                                this.serverPublicKey = PublicKeyFactory.createKey(keyInfo);
                            }
                            catch (RuntimeException e) {
                                this.failWithError((short)2, (short)43);
                            }
                            if (this.serverPublicKey.isPrivate()) {
                                this.failWithError((short)2, (short)80);
                            }
                            switch (this.chosenCipherSuite.getKeyExchangeAlgorithm()) {
                                case 1: {
                                    if (!(this.serverPublicKey instanceof RSAKeyParameters)) {
                                        this.failWithError((short)2, (short)46);
                                    }
                                    this.validateKeyUsage(x509Cert, 32);
                                    break;
                                }
                                case 5: 
                                case 11: {
                                    if (!(this.serverPublicKey instanceof RSAKeyParameters)) {
                                        this.failWithError((short)2, (short)46);
                                    }
                                    this.validateKeyUsage(x509Cert, 128);
                                    break;
                                }
                                case 3: 
                                case 12: {
                                    if (this.serverPublicKey instanceof DSAPublicKeyParameters) break;
                                    this.failWithError((short)2, (short)46);
                                    break;
                                }
                                default: {
                                    this.failWithError((short)2, (short)43);
                                }
                            }
                            if (this.verifyer.isValid(cert.getCerts())) break;
                            this.failWithError((short)2, (short)90);
                            break;
                        }
                        default: {
                            this.failWithError((short)2, (short)10);
                        }
                    }
                    this.connection_state = (short)3;
                    read = true;
                    break;
                }
                case 20: {
                    switch (this.connection_state) {
                        case 11: {
                            byte[] receivedChecksum = new byte[12];
                            TlsUtils.readFully(receivedChecksum, is);
                            this.assertEmpty(is);
                            byte[] checksum = new byte[12];
                            byte[] md5andsha1 = new byte[36];
                            this.rs.hash2.doFinal(md5andsha1, 0);
                            TlsUtils.PRF(this.ms, TlsUtils.toByteArray("server finished"), md5andsha1, checksum);
                            int i = 0;
                            while (i < receivedChecksum.length) {
                                if (receivedChecksum[i] != checksum[i]) {
                                    this.failWithError((short)2, (short)40);
                                }
                                ++i;
                            }
                            this.connection_state = (short)12;
                            this.appDataReady = true;
                            read = true;
                            break block2;
                        }
                    }
                    this.failWithError((short)2, (short)10);
                    break;
                }
                case 2: {
                    switch (this.connection_state) {
                        case 1: {
                            TlsUtils.checkVersion(is, this);
                            this.serverRandom = new byte[32];
                            TlsUtils.readFully(this.serverRandom, is);
                            byte[] sessionId = TlsUtils.readOpaque8(is);
                            this.chosenCipherSuite = TlsCipherSuiteManager.getCipherSuite(TlsUtils.readUint16(is), this);
                            short compressionMethod = TlsUtils.readUint8(is);
                            if (compressionMethod != 0) {
                                this.failWithError((short)2, (short)47);
                            }
                            if (this.extendedClientHello && is.available() > 0) {
                                byte[] extBytes = TlsUtils.readOpaque16(is);
                                Hashtable<Integer, byte[]> serverExtensions = new Hashtable<Integer, byte[]>();
                                ByteArrayInputStream ext = new ByteArrayInputStream(extBytes);
                                while (ext.available() > 0) {
                                    int extType = TlsUtils.readUint16(ext);
                                    byte[] extValue = TlsUtils.readOpaque16(ext);
                                    serverExtensions.put(new Integer(extType), extValue);
                                }
                            }
                            this.assertEmpty(is);
                            this.connection_state = (short)2;
                            read = true;
                            break block2;
                        }
                    }
                    this.failWithError((short)2, (short)10);
                    break;
                }
                case 14: {
                    switch (this.connection_state) {
                        case 3: {
                            if (this.chosenCipherSuite.getKeyExchangeAlgorithm() != 1) {
                                this.failWithError((short)2, (short)10);
                            }
                        }
                        case 4: 
                        case 5: {
                            this.assertEmpty(is);
                            boolean isCertReq = this.connection_state == 5;
                            this.connection_state = (short)6;
                            if (isCertReq) {
                                this.sendClientCertificate();
                            }
                            switch (this.chosenCipherSuite.getKeyExchangeAlgorithm()) {
                                case 1: {
                                    this.pms = new byte[48];
                                    this.random.nextBytes(this.pms);
                                    this.pms[0] = 3;
                                    this.pms[1] = 1;
                                    RSABlindedEngine rsa = new RSABlindedEngine();
                                    PKCS1Encoding encoding = new PKCS1Encoding(rsa);
                                    encoding.init(true, new ParametersWithRandom(this.serverPublicKey, this.random));
                                    byte[] encrypted = null;
                                    try {
                                        encrypted = encoding.processBlock(this.pms, 0, this.pms.length);
                                    }
                                    catch (InvalidCipherTextException e) {
                                        this.failWithError((short)2, (short)80);
                                    }
                                    this.sendClientKeyExchange(encrypted);
                                    break;
                                }
                                case 3: 
                                case 5: {
                                    byte[] YcByte = BigIntegers.asUnsignedByteArray(this.Yc);
                                    this.sendClientKeyExchange(YcByte);
                                    break;
                                }
                                case 10: 
                                case 11: 
                                case 12: {
                                    byte[] bytes = BigIntegers.asUnsignedByteArray(this.SRP_A);
                                    this.sendClientKeyExchange(bytes);
                                    break;
                                }
                                default: {
                                    this.failWithError((short)2, (short)10);
                                }
                            }
                            this.connection_state = (short)7;
                            byte[] cmessage = new byte[]{1};
                            this.rs.writeMessage((short)20, cmessage, 0, cmessage.length);
                            this.connection_state = (short)9;
                            this.ms = new byte[48];
                            byte[] random = new byte[this.clientRandom.length + this.serverRandom.length];
                            System.arraycopy(this.clientRandom, 0, random, 0, this.clientRandom.length);
                            System.arraycopy(this.serverRandom, 0, random, this.clientRandom.length, this.serverRandom.length);
                            TlsUtils.PRF(this.pms, TlsUtils.toByteArray("master secret"), random, this.ms);
                            this.rs.writeSuite = this.chosenCipherSuite;
                            this.rs.writeSuite.init(this.ms, this.clientRandom, this.serverRandom);
                            byte[] checksum = new byte[12];
                            byte[] md5andsha1 = new byte[36];
                            this.rs.hash1.doFinal(md5andsha1, 0);
                            TlsUtils.PRF(this.ms, TlsUtils.toByteArray("client finished"), md5andsha1, checksum);
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            TlsUtils.writeUint8((short)20, bos);
                            TlsUtils.writeUint24(12, bos);
                            bos.write(checksum);
                            byte[] message = bos.toByteArray();
                            this.rs.writeMessage((short)22, message, 0, message.length);
                            this.connection_state = (short)10;
                            read = true;
                            break block2;
                        }
                    }
                    this.failWithError((short)2, (short)40);
                    break;
                }
                case 12: {
                    block33 : switch (this.connection_state) {
                        case 2: {
                            if (this.chosenCipherSuite.getKeyExchangeAlgorithm() != 10) {
                                this.failWithError((short)2, (short)10);
                            }
                        }
                        case 3: {
                            switch (this.chosenCipherSuite.getKeyExchangeAlgorithm()) {
                                case 5: {
                                    this.processDHEKeyExchange(is, new TlsRSASigner());
                                    break block33;
                                }
                                case 3: {
                                    this.processDHEKeyExchange(is, new TlsDSSSigner());
                                    break block33;
                                }
                                case 10: {
                                    this.processSRPKeyExchange(is, null);
                                    break block33;
                                }
                                case 11: {
                                    this.processSRPKeyExchange(is, new TlsRSASigner());
                                    break block33;
                                }
                                case 12: {
                                    this.processSRPKeyExchange(is, new TlsDSSSigner());
                                    break block33;
                                }
                            }
                            this.failWithError((short)2, (short)10);
                            break;
                        }
                        default: {
                            this.failWithError((short)2, (short)10);
                        }
                    }
                    this.connection_state = (short)4;
                    read = true;
                    break;
                }
                case 13: {
                    switch (this.connection_state) {
                        case 3: {
                            if (this.chosenCipherSuite.getKeyExchangeAlgorithm() != 1) {
                                this.failWithError((short)2, (short)10);
                            }
                        }
                        case 4: {
                            byte[] types = TlsUtils.readOpaque8(is);
                            byte[] auths = TlsUtils.readOpaque8(is);
                            this.assertEmpty(is);
                            break;
                        }
                        default: {
                            this.failWithError((short)2, (short)10);
                        }
                    }
                    this.connection_state = (short)5;
                    read = true;
                    break;
                }
                default: {
                    this.failWithError((short)2, (short)10);
                }
            }
        } while (read);
    }

    private void processApplicationData() {
    }

    private void processAlert() throws IOException {
        while (this.alertQueue.size() >= 2) {
            byte[] tmp = new byte[2];
            this.alertQueue.read(tmp, 0, 2, 0);
            this.alertQueue.removeData(2);
            byte level = tmp[0];
            byte description = tmp[1];
            if (level == 2) {
                this.failedWithError = true;
                this.closed = true;
                try {
                    this.rs.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new IOException(TLS_ERROR_MESSAGE);
            }
            if (description != 0) continue;
            this.failWithError((short)1, (short)0);
        }
    }

    private void processChangeCipherSpec() throws IOException {
        while (this.changeCipherSpecQueue.size() > 0) {
            byte[] b = new byte[1];
            this.changeCipherSpecQueue.read(b, 0, 1, 0);
            this.changeCipherSpecQueue.removeData(1);
            if (b[0] != 1) {
                this.failWithError((short)2, (short)10);
                continue;
            }
            if (this.connection_state == 10) {
                this.rs.readSuite = this.rs.writeSuite;
                this.connection_state = (short)11;
                continue;
            }
            this.failWithError((short)2, (short)40);
        }
    }

    private void processDHEKeyExchange(ByteArrayInputStream is, Signer signer) throws IOException {
        byte[] sigByte;
        InputStream sigIn = is;
        if (signer != null) {
            signer.init(false, this.serverPublicKey);
            signer.update(this.clientRandom, 0, this.clientRandom.length);
            signer.update(this.serverRandom, 0, this.serverRandom.length);
            sigIn = new SignerInputStream(is, signer);
        }
        byte[] pByte = TlsUtils.readOpaque16(sigIn);
        byte[] gByte = TlsUtils.readOpaque16(sigIn);
        byte[] YsByte = TlsUtils.readOpaque16(sigIn);
        if (signer != null && !signer.verifySignature(sigByte = TlsUtils.readOpaque16(is))) {
            this.failWithError((short)2, (short)42);
        }
        this.assertEmpty(is);
        BigInteger p = new BigInteger(1, pByte);
        BigInteger g = new BigInteger(1, gByte);
        BigInteger Ys = new BigInteger(1, YsByte);
        if (!p.isProbablePrime(10)) {
            this.failWithError((short)2, (short)47);
        }
        if (g.compareTo(TWO) < 0 || g.compareTo(p.subtract(TWO)) > 0) {
            this.failWithError((short)2, (short)47);
        }
        if (Ys.compareTo(TWO) < 0 || Ys.compareTo(p.subtract(ONE)) > 0) {
            this.failWithError((short)2, (short)47);
        }
        DHParameters dhParams = new DHParameters(p, g);
        DHBasicKeyPairGenerator dhGen = new DHBasicKeyPairGenerator();
        dhGen.init(new DHKeyGenerationParameters(this.random, dhParams));
        AsymmetricCipherKeyPair dhPair = dhGen.generateKeyPair();
        this.Yc = ((DHPublicKeyParameters)dhPair.getPublic()).getY();
        DHBasicAgreement dhAgree = new DHBasicAgreement();
        dhAgree.init(dhPair.getPrivate());
        BigInteger agreement = dhAgree.calculateAgreement(new DHPublicKeyParameters(Ys, dhParams));
        this.pms = BigIntegers.asUnsignedByteArray(agreement);
    }

    private void processSRPKeyExchange(ByteArrayInputStream is, Signer signer) throws IOException {
        byte[] sigByte;
        InputStream sigIn = is;
        if (signer != null) {
            signer.init(false, this.serverPublicKey);
            signer.update(this.clientRandom, 0, this.clientRandom.length);
            signer.update(this.serverRandom, 0, this.serverRandom.length);
            sigIn = new SignerInputStream(is, signer);
        }
        byte[] NByte = TlsUtils.readOpaque16(sigIn);
        byte[] gByte = TlsUtils.readOpaque16(sigIn);
        byte[] sByte = TlsUtils.readOpaque8(sigIn);
        byte[] BByte = TlsUtils.readOpaque16(sigIn);
        if (signer != null && !signer.verifySignature(sigByte = TlsUtils.readOpaque16(is))) {
            this.failWithError((short)2, (short)42);
        }
        this.assertEmpty(is);
        BigInteger N = new BigInteger(1, NByte);
        BigInteger g = new BigInteger(1, gByte);
        byte[] s = sByte;
        BigInteger B = new BigInteger(1, BByte);
        SRP6Client srpClient = new SRP6Client();
        srpClient.init(N, g, new SHA1Digest(), this.random);
        this.SRP_A = srpClient.generateClientCredentials(s, this.SRP_identity, this.SRP_password);
        try {
            BigInteger S = srpClient.calculateSecret(B);
            this.pms = BigIntegers.asUnsignedByteArray(S);
        }
        catch (CryptoException e) {
            this.failWithError((short)2, (short)47);
        }
    }

    private void validateKeyUsage(X509CertificateStructure c, int keyUsageBits) throws IOException {
        DERBitString ku;
        int bits;
        X509Extension ext;
        X509Extensions exts = c.getTBSCertificate().getExtensions();
        if (exts != null && (ext = exts.getExtension(X509Extensions.KeyUsage)) != null && ((bits = (ku = KeyUsage.getInstance(ext)).getBytes()[0] & 0xFF) & keyUsageBits) != keyUsageBits) {
            this.failWithError((short)2, (short)46);
        }
    }

    private void sendClientCertificate() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)11, bos);
        TlsUtils.writeUint24(3, bos);
        TlsUtils.writeUint24(0, bos);
        byte[] message = bos.toByteArray();
        this.rs.writeMessage((short)22, message, 0, message.length);
    }

    private void sendClientKeyExchange(byte[] keData) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)16, bos);
        TlsUtils.writeUint24(keData.length + 2, bos);
        TlsUtils.writeOpaque16(keData, bos);
        byte[] message = bos.toByteArray();
        this.rs.writeMessage((short)22, message, 0, message.length);
    }

    public void connect(CertificateVerifyer verifyer) throws IOException {
        this.verifyer = verifyer;
        this.clientRandom = new byte[32];
        this.random.nextBytes(this.clientRandom);
        int t = (int)(System.currentTimeMillis() / 1000L);
        this.clientRandom[0] = (byte)(t >> 24);
        this.clientRandom[1] = (byte)(t >> 16);
        this.clientRandom[2] = (byte)(t >> 8);
        this.clientRandom[3] = (byte)t;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TlsUtils.writeVersion(os);
        os.write(this.clientRandom);
        TlsUtils.writeUint8((short)0, os);
        TlsCipherSuiteManager.writeCipherSuites(os);
        byte[] compressionMethods = new byte[1];
        TlsUtils.writeOpaque8(compressionMethods, os);
        Hashtable clientExtensions = new Hashtable();
        boolean bl = this.extendedClientHello = !clientExtensions.isEmpty();
        if (this.extendedClientHello) {
            ByteArrayOutputStream ext = new ByteArrayOutputStream();
            Enumeration keys = clientExtensions.keys();
            while (keys.hasMoreElements()) {
                Integer extType = (Integer)keys.nextElement();
                byte[] extValue = (byte[])clientExtensions.get(extType);
                TlsUtils.writeUint16(extType, ext);
                TlsUtils.writeOpaque16(extValue, ext);
            }
            TlsUtils.writeOpaque16(ext.toByteArray(), os);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)1, bos);
        TlsUtils.writeUint24(os.size(), bos);
        bos.write(os.toByteArray());
        byte[] message = bos.toByteArray();
        this.rs.writeMessage((short)22, message, 0, message.length);
        this.connection_state = 1;
        while (this.connection_state != 12) {
            this.rs.readData();
        }
        this.tlsInputStream = new TlsInputStream(this);
        this.tlsOutputStream = new TlsOuputStream(this);
    }

    protected int readApplicationData(byte[] buf, int offset, int len) throws IOException {
        while (this.applicationDataQueue.size() == 0) {
            if (this.failedWithError) {
                throw new IOException(TLS_ERROR_MESSAGE);
            }
            if (this.closed) {
                return -1;
            }
            try {
                this.rs.readData();
            }
            catch (IOException e) {
                if (!this.closed) {
                    this.failWithError((short)2, (short)80);
                }
                throw e;
            }
            catch (RuntimeException e) {
                if (!this.closed) {
                    this.failWithError((short)2, (short)80);
                }
                throw e;
            }
        }
        len = Math.min(len, this.applicationDataQueue.size());
        this.applicationDataQueue.read(buf, offset, len, 0);
        this.applicationDataQueue.removeData(len);
        return len;
    }

    protected void writeData(byte[] buf, int offset, int len) throws IOException {
        int toWrite;
        if (this.failedWithError) {
            throw new IOException(TLS_ERROR_MESSAGE);
        }
        if (this.closed) {
            throw new IOException("Sorry, connection has been closed, you cannot write more data");
        }
        this.rs.writeMessage((short)23, emptybuf, 0, 0);
        do {
            toWrite = Math.min(len, 16384);
            try {
                this.rs.writeMessage((short)23, buf, offset, toWrite);
            }
            catch (IOException e) {
                if (!this.closed) {
                    this.failWithError((short)2, (short)80);
                }
                throw e;
            }
            catch (RuntimeException e) {
                if (!this.closed) {
                    this.failWithError((short)2, (short)80);
                }
                throw e;
            }
            offset += toWrite;
        } while ((len -= toWrite) > 0);
    }

    public TlsOuputStream getTlsOuputStream() {
        return this.tlsOutputStream;
    }

    public OutputStream getOutputStream() {
        return this.tlsOutputStream;
    }

    public TlsInputStream getTlsInputStream() {
        return this.tlsInputStream;
    }

    public InputStream getInputStream() {
        return this.tlsInputStream;
    }

    protected void failWithError(short alertLevel, short alertDescription) throws IOException {
        if (!this.closed) {
            byte[] error = new byte[]{(byte)alertLevel, (byte)alertDescription};
            this.closed = true;
            if (alertLevel == 2) {
                this.failedWithError = true;
            }
            this.rs.writeMessage((short)21, error, 0, 2);
            this.rs.close();
            if (alertLevel == 2) {
                throw new IOException(TLS_ERROR_MESSAGE);
            }
        } else {
            throw new IOException(TLS_ERROR_MESSAGE);
        }
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.failWithError((short)1, (short)0);
        }
    }

    protected void assertEmpty(ByteArrayInputStream is) throws IOException {
        if (is.available() > 0) {
            this.failWithError((short)2, (short)50);
        }
    }

    protected void flush() throws IOException {
        this.rs.flush();
    }
}

