/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.util;

import com.sansec.asn1.ASN1InputStream;
import com.sansec.asn1.ASN1Object;
import com.sansec.asn1.ASN1Sequence;
import com.sansec.asn1.DERBitString;
import com.sansec.asn1.DEREncodable;
import com.sansec.asn1.DERInteger;
import com.sansec.asn1.DERObject;
import com.sansec.asn1.DERObjectIdentifier;
import com.sansec.asn1.DEROctetString;
import com.sansec.asn1.nist.NISTNamedCurves;
import com.sansec.asn1.oiw.ElGamalParameter;
import com.sansec.asn1.oiw.OIWObjectIdentifiers;
import com.sansec.asn1.pkcs.DHParameter;
import com.sansec.asn1.pkcs.PKCSObjectIdentifiers;
import com.sansec.asn1.sec.SECNamedCurves;
import com.sansec.asn1.teletrust.TeleTrusTNamedCurves;
import com.sansec.asn1.x509.AlgorithmIdentifier;
import com.sansec.asn1.x509.DSAParameter;
import com.sansec.asn1.x509.RSAPublicKeyStructure;
import com.sansec.asn1.x509.SubjectPublicKeyInfo;
import com.sansec.asn1.x509.X509ObjectIdentifiers;
import com.sansec.asn1.x9.X962NamedCurves;
import com.sansec.asn1.x9.X962Parameters;
import com.sansec.asn1.x9.X9ECParameters;
import com.sansec.asn1.x9.X9ECPoint;
import com.sansec.asn1.x9.X9ObjectIdentifiers;
import com.sansec.crypto.params.AsymmetricKeyParameter;
import com.sansec.crypto.params.DHParameters;
import com.sansec.crypto.params.DHPublicKeyParameters;
import com.sansec.crypto.params.DSAParameters;
import com.sansec.crypto.params.DSAPublicKeyParameters;
import com.sansec.crypto.params.ECDomainParameters;
import com.sansec.crypto.params.ECPublicKeyParameters;
import com.sansec.crypto.params.ElGamalParameters;
import com.sansec.crypto.params.ElGamalPublicKeyParameters;
import com.sansec.crypto.params.RSAKeyParameters;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class PublicKeyFactory {
    public static AsymmetricKeyParameter createKey(byte[] keyInfoData) throws IOException {
        return PublicKeyFactory.createKey(SubjectPublicKeyInfo.getInstance(ASN1Object.fromByteArray(keyInfoData)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inStr) throws IOException {
        return PublicKeyFactory.createKey(SubjectPublicKeyInfo.getInstance(new ASN1InputStream(inStr).readObject()));
    }

    public static AsymmetricKeyParameter createKey(SubjectPublicKeyInfo keyInfo) throws IOException {
        AlgorithmIdentifier algId = keyInfo.getAlgorithmId();
        if (algId.getObjectId().equals(PKCSObjectIdentifiers.rsaEncryption) || algId.getObjectId().equals(X509ObjectIdentifiers.id_ea_rsa)) {
            RSAPublicKeyStructure pubKey = new RSAPublicKeyStructure((ASN1Sequence)keyInfo.getPublicKey());
            return new RSAKeyParameters(false, pubKey.getModulus(), pubKey.getPublicExponent());
        }
        if (algId.getObjectId().equals(PKCSObjectIdentifiers.dhKeyAgreement) || algId.getObjectId().equals(X9ObjectIdentifiers.dhpublicnumber)) {
            DHParameter params = new DHParameter((ASN1Sequence)keyInfo.getAlgorithmId().getParameters());
            DERInteger derY = (DERInteger)keyInfo.getPublicKey();
            BigInteger lVal = params.getL();
            int l = lVal == null ? 0 : lVal.intValue();
            DHParameters dhParams = new DHParameters(params.getP(), params.getG(), null, l);
            return new DHPublicKeyParameters(derY.getValue(), dhParams);
        }
        if (algId.getObjectId().equals(OIWObjectIdentifiers.elGamalAlgorithm)) {
            ElGamalParameter params = new ElGamalParameter((ASN1Sequence)keyInfo.getAlgorithmId().getParameters());
            DERInteger derY = (DERInteger)keyInfo.getPublicKey();
            return new ElGamalPublicKeyParameters(derY.getValue(), new ElGamalParameters(params.getP(), params.getG()));
        }
        if (algId.getObjectId().equals(X9ObjectIdentifiers.id_dsa) || algId.getObjectId().equals(OIWObjectIdentifiers.dsaWithSHA1)) {
            DERInteger derY = (DERInteger)keyInfo.getPublicKey();
            DEREncodable de = keyInfo.getAlgorithmId().getParameters();
            DSAParameters parameters = null;
            if (de != null) {
                DSAParameter params = DSAParameter.getInstance(de.getDERObject());
                parameters = new DSAParameters(params.getP(), params.getQ(), params.getG());
            }
            return new DSAPublicKeyParameters(derY.getValue(), parameters);
        }
        if (algId.getObjectId().equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            X962Parameters params = new X962Parameters((DERObject)keyInfo.getAlgorithmId().getParameters());
            ECDomainParameters dParams = null;
            if (params.isNamedCurve()) {
                DERObjectIdentifier oid = (DERObjectIdentifier)params.getParameters();
                X9ECParameters ecP = X962NamedCurves.getByOID(oid);
                if (ecP == null && (ecP = SECNamedCurves.getByOID(oid)) == null && (ecP = NISTNamedCurves.getByOID(oid)) == null) {
                    ecP = TeleTrusTNamedCurves.getByOID(oid);
                }
                dParams = new ECDomainParameters(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
            } else {
                X9ECParameters ecP = new X9ECParameters((ASN1Sequence)params.getParameters());
                dParams = new ECDomainParameters(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
            }
            DERBitString bits = keyInfo.getPublicKeyData();
            byte[] data = bits.getBytes();
            DEROctetString key = new DEROctetString(data);
            X9ECPoint derQ = new X9ECPoint(dParams.getCurve(), key);
            return new ECPublicKeyParameters(derQ.getPoint(), dParams);
        }
        throw new RuntimeException("algorithm identifier in key not recognised");
    }
}

