/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.device;

import com.sansec.device.bean.GlobalData;
import com.sansec.device.bean.config.ParseConfigException;
import com.sansec.device.bean.config.Profile;
import com.sansec.device.crypto.CryptoException;
import com.sansec.device.crypto.ISDSCrypto;
import com.sansec.device.sds.CardDevice;
import com.sansec.device.sds.CryptoDevice;
import com.sansec.device.sds.HSMDevice;
import com.sansec.device.socket.HSMPool;
import java.util.logging.Logger;

public class SDSFactory {
    public static final int SOFT = 0;
    public static final int CARD = 1;
    public static final int HSMM = 2;
    private static Logger logger = GlobalData.logger;
    private static ISDSCrypto instance = null;
    private static Profile profile = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ISDSCrypto getInstance() throws CryptoException {
        if (instance != null) return instance;
        Class<SDSFactory> clazz = SDSFactory.class;
        synchronized (SDSFactory.class) {
            block10: {
                if (instance != null) return instance;
                try {
                    if (SDSFactory.isCard()) {
                        logger.info("Crypto Device is Card");
                        try {
                            instance = new CryptoDevice(new CardDevice());
                            break block10;
                        }
                        catch (Exception ex) {
                            throw new CryptoException("\u5bc6\u7801\u5361\u521d\u59cb\u5316\u5931\u8d25: " + ex.getMessage());
                        }
                    }
                    logger.info("Crypto Device is HSM");
                    try {
                        HSMPool pool = HSMPool.getPool();
                        pool.initialize(profile.getConnectPoolSize(), profile.getServer(), profile.getConnectTimeout(), profile.getServiceTimeout());
                        instance = new CryptoDevice(new HSMDevice());
                    }
                    catch (Exception ex) {
                        throw new CryptoException("\u5bc6\u7801\u673a\u521d\u59cb\u5316\u8fde\u63a5\u5931\u8d25: " + ex.getMessage());
                    }
                }
                catch (Exception ex) {
                    instance = null;
                    logger.severe(ex.getMessage());
                    throw new CryptoException(ex.getMessage());
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static boolean isCard() {
        String path = Profile.findCoinfigFilePath();
        if (path == null) {
            return true;
        }
        profile = new Profile();
        try {
            profile.loadConfig(path);
        }
        catch (ParseConfigException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return 2 != profile.getDeviceType();
    }
}

