/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.device.bean;

import com.sansec.device.bean.inf.IStructure;
import com.sansec.util.Bytes;

public class DeviceInfo
implements IStructure {
    private String isssuerName;
    private String deviceName;
    private String deviceSerial;
    private int deviceVersion;
    private int standardVersion;
    private int[] ayslgAbility = new int[2];
    private int symAlgAbility;
    private int hashAlgAbility;
    private int bufferSize;

    public String getIssuserName() {
        return this.isssuerName;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getDeviceSerial() {
        return this.deviceSerial;
    }

    public int getDeviceVersion() {
        return this.deviceVersion;
    }

    public int getStandardVersion() {
        return this.standardVersion;
    }

    public void decode(byte[] deviceData) {
        byte[] buf = null;
        int offset = 0;
        int n = 0;
        while (n < 40) {
            if (deviceData[offset + n] == 0) break;
            ++n;
        }
        buf = new byte[n];
        System.arraycopy(deviceData, offset, buf, 0, buf.length);
        offset += 40;
        this.isssuerName = new String(buf);
        n = 0;
        while (n < 16) {
            if (deviceData[offset + n] == 0) break;
            ++n;
        }
        buf = new byte[n];
        System.arraycopy(deviceData, offset, buf, 0, buf.length);
        offset += 16;
        this.deviceName = new String(buf);
        n = 0;
        while (n < 16) {
            if (deviceData[offset + n] == 0) break;
            ++n;
        }
        buf = new byte[n];
        System.arraycopy(deviceData, offset, buf, 0, buf.length);
        this.deviceSerial = new String(buf);
        this.deviceVersion = Bytes.bytes2int(deviceData, offset += 16);
        this.standardVersion = Bytes.bytes2int(deviceData, offset += 4);
        this.ayslgAbility[0] = Bytes.bytes2int(deviceData, offset += 4);
        this.ayslgAbility[1] = Bytes.bytes2int(deviceData, offset += 4);
        this.symAlgAbility = Bytes.bytes2int(deviceData, offset += 4);
        this.hashAlgAbility = Bytes.bytes2int(deviceData, offset += 4);
        this.hashAlgAbility |= 0xBF;
        this.bufferSize = Bytes.bytes2int(deviceData, offset += 4);
        offset += 4;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buf.append("    |    project          |   value  ").append(nl);
        buf.append("   _|_____________________|______________________________________________________").append(nl);
        buf.append("   1| Manufacturers       | ").append(this.isssuerName).append(nl);
        buf.append("   2| Device model        | ").append(this.deviceName).append(nl);
        buf.append("   3| Serial number       | ").append(this.deviceSerial).append(nl);
        buf.append("   4| Device version      | ").append("v" + this.toHexString(this.deviceVersion)).append(nl);
        buf.append("   5| Standard version    | ").append("v" + this.toHexString(this.standardVersion)).append(nl);
        buf.append("   6| Public key algorithm| ").append(String.valueOf(this.toHexString(this.ayslgAbility[0])) + " | " + this.toHexString(this.ayslgAbility[1])).append(nl);
        buf.append("   7| Symmetric algorithm | ").append(this.toHexString(this.symAlgAbility)).append(nl);
        buf.append("   8| Hash algorithm      | ").append(this.toHexString(this.hashAlgAbility)).append(nl);
        buf.append("   9| User memory space   | ").append(String.valueOf(this.bufferSize / 1024) + "KB").append(nl);
        return buf.toString();
    }

    public int size() {
        return 0;
    }

    public byte[] encode() {
        return null;
    }

    private String toHexString(int n) {
        String str = Integer.toHexString(n);
        while (str.length() < 8) {
            str = "0" + str;
        }
        return str;
    }
}

