/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.device.bean;

import com.sansec.device.bean.inf.IRSArefPrivateKey;
import com.sansec.util.Bytes;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;

public class ExRSArefPrivateKey
implements IRSArefPrivateKey {
    private int bits;
    private byte[] n = new byte[512];
    private byte[] e = new byte[512];
    private byte[] d = new byte[512];
    private byte[] p1 = new byte[256];
    private byte[] p2 = new byte[256];
    private byte[] q1 = new byte[256];
    private byte[] q2 = new byte[256];
    private byte[] coef = new byte[256];

    public ExRSArefPrivateKey(byte[] n, byte[] e, byte[] d, byte[] p1, byte[] p2, byte[] q1, byte[] q2, byte[] coef) {
        if (n.length > 513) {
            throw new RuntimeException("n length[ " + n.length + " ]");
        }
        if (n[0] == 0 && n.length % 256 == 1) {
            this.bits = n.length - 1 << 3;
            System.arraycopy(n, 1, this.n, 512 - (n.length - 1), n.length - 1);
        } else {
            this.bits = n.length << 3;
            System.arraycopy(n, 0, this.n, 512 - n.length, n.length);
        }
        if (e.length > 513) {
            throw new RuntimeException("e length[ " + e.length + " ]");
        }
        if (e[0] == 0 && e.length % 256 == 1) {
            System.arraycopy(e, 1, this.e, 512 - (e.length - 1), e.length - 1);
        } else {
            System.arraycopy(e, 0, this.e, 512 - e.length, e.length);
        }
        if (d.length > 513) {
            throw new RuntimeException("d length[ " + d.length + " ]");
        }
        if (d[0] == 0 && d.length % 256 == 1) {
            System.arraycopy(d, 1, this.d, 512 - (d.length - 1), d.length - 1);
        } else {
            System.arraycopy(d, 0, this.d, 512 - d.length, d.length);
        }
        if (p1.length > 257) {
            throw new RuntimeException("p1 length[ " + p1.length + " ]");
        }
        if (p1[0] == 0 && p1.length % 128 == 1) {
            System.arraycopy(p1, 1, this.p1, 256 - (p1.length - 1), p1.length - 1);
        } else {
            System.arraycopy(p1, 0, this.p1, 256 - p1.length, p1.length);
        }
        if (p2.length > 257) {
            throw new RuntimeException("p2 length[ " + p2.length + " ]");
        }
        if (p2[0] == 0 && p2.length % 128 == 1) {
            System.arraycopy(p2, 1, this.p2, 256 - (p2.length - 1), p2.length - 1);
        } else {
            System.arraycopy(p2, 0, this.p2, 256 - p2.length, p2.length);
        }
        if (q1.length > 257) {
            throw new RuntimeException("q1 length[ " + q1.length + " ]");
        }
        if (q1[0] == 0 && q1.length % 128 == 1) {
            System.arraycopy(q1, 1, this.q1, 256 - (q1.length - 1), q1.length - 1);
        } else {
            System.arraycopy(q1, 0, this.q1, 256 - q1.length, q1.length);
        }
        if (q2.length > 257) {
            throw new RuntimeException("q2 length[ " + q2.length + " ]");
        }
        if (q2[0] == 0 && q2.length % 128 == 1) {
            System.arraycopy(q2, 1, this.q2, 256 - (q2.length - 1), q2.length - 1);
        } else {
            System.arraycopy(q2, 0, this.q2, 256 - q2.length, q2.length);
        }
        if (coef.length > 257) {
            throw new RuntimeException("coef length[ " + coef.length + " ]");
        }
        if (coef[0] == 0 && coef.length % 128 == 1) {
            System.arraycopy(coef, 1, this.coef, 256 - (coef.length - 1), coef.length - 1);
        } else {
            System.arraycopy(coef, 0, this.coef, 256 - coef.length, coef.length);
        }
    }

    public ExRSArefPrivateKey() {
    }

    public int getBits() {
        return this.bits;
    }

    public byte[] getN() {
        return this.n;
    }

    public byte[] getE() {
        return this.e;
    }

    public byte[] getD() {
        return this.d;
    }

    public byte[] getPrime1() {
        return this.p1;
    }

    public byte[] getPrime2() {
        return this.p2;
    }

    public byte[] getDPrime1() {
        return this.q1;
    }

    public byte[] getDPrime2() {
        return this.q2;
    }

    public byte[] getCoef() {
        return this.coef;
    }

    public void decode(byte[] bytes) {
        this.bits = Bytes.bytes2int(bytes);
        int pos = 4;
        System.arraycopy(bytes, pos, this.n, 0, 512);
        System.arraycopy(bytes, pos += this.n.length, this.e, 0, 512);
        System.arraycopy(bytes, pos += this.e.length, this.d, 0, 512);
        System.arraycopy(bytes, pos += this.d.length, this.p1, 0, 256);
        System.arraycopy(bytes, pos += this.p1.length, this.p2, 0, 256);
        System.arraycopy(bytes, pos += this.p2.length, this.q1, 0, 256);
        System.arraycopy(bytes, pos += this.q1.length, this.q2, 0, 256);
        System.arraycopy(bytes, pos += this.q2.length, this.coef, 0, 256);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buf.append(nl);
        buf.append("bits: ").append(this.bits).append(nl);
        buf.append("   n: ").append(new BigInteger(1, this.n).toString(16)).append(nl);
        buf.append("   e: ").append(new BigInteger(1, this.e).toString(16)).append(nl);
        buf.append("   d: ").append(new BigInteger(1, this.d).toString(16)).append(nl);
        buf.append("   p: ").append(new BigInteger(1, this.p1).toString(16)).append(nl);
        buf.append("   q: ").append(new BigInteger(1, this.p2).toString(16)).append(nl);
        buf.append("  dp: ").append(new BigInteger(1, this.q1).toString(16)).append(nl);
        buf.append("  dq: ").append(new BigInteger(1, this.q2).toString(16)).append(nl);
        buf.append("coef: ").append(new BigInteger(1, this.coef).toString(16)).append(nl);
        return buf.toString();
    }

    public byte[] encode() {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            buf.write(Bytes.int2bytes(this.bits));
            buf.write(this.n);
            buf.write(this.e);
            buf.write(this.d);
            buf.write(this.p1);
            buf.write(this.p2);
            buf.write(this.q1);
            buf.write(this.q2);
            buf.write(this.coef);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buf.toByteArray();
    }

    public int size() {
        return 2820;
    }
}

