/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.device.bean;

import com.sansec.device.bean.inf.IRSArefPublicKey;
import com.sansec.util.Bytes;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;

public class ExRSArefPublicKey
implements IRSArefPublicKey {
    public int bits;
    private byte[] n = new byte[512];
    private byte[] e = new byte[512];

    public ExRSArefPublicKey(byte[] n, byte[] e) {
        if (n.length > 513) {
            throw new RuntimeException("n length[ " + n.length + " ]");
        }
        if (n[0] == 0 && n.length % 256 == 1) {
            this.bits = n.length - 1 << 3;
            System.arraycopy(n, 1, this.n, 512 - (n.length - 1), n.length - 1);
        } else {
            this.bits = n.length << 3;
            System.arraycopy(n, 0, this.n, 512 - n.length, n.length);
        }
        if (e.length > 513) {
            throw new RuntimeException("e length[ " + e.length + " ]");
        }
        if (e[0] == 0 && e.length % 256 == 1) {
            System.arraycopy(e, 1, this.e, 512 - (e.length - 1), e.length - 1);
        } else {
            System.arraycopy(e, 0, this.e, 512 - e.length, e.length);
        }
    }

    public ExRSArefPublicKey() {
    }

    public byte[] getN() {
        return this.n;
    }

    public byte[] getE() {
        return this.e;
    }

    public int getBits() {
        return this.bits;
    }

    public void decode(byte[] bytes) {
        this.bits = Bytes.bytes2int(bytes);
        int pos = 4;
        System.arraycopy(bytes, pos, this.n, 0, 512);
        System.arraycopy(bytes, pos += this.n.length, this.e, 0, 512);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buf.append(nl);
        buf.append("bits: ").append(this.bits).append(nl);
        buf.append("   n: ").append(new BigInteger(1, this.n).toString(16)).append(nl);
        buf.append("   e: ").append(new BigInteger(1, this.e).toString(16)).append(nl);
        return buf.toString();
    }

    public byte[] encode() {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            buf.write(Bytes.int2bytes(this.bits));
            buf.write(this.n);
            buf.write(this.e);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buf.toByteArray();
    }

    public int size() {
        return 1028;
    }
}

