/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.device.bean;

import com.sansec.device.bean.inf.IStructure;
import com.sansec.util.Bytes;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;

public class SM2refCipher
implements IStructure {
    private int cLength;
    private byte[] x = new byte[32];
    private byte[] y = new byte[32];
    private byte[] c = new byte[136];
    private byte[] m = new byte[32];

    public SM2refCipher() {
    }

    public SM2refCipher(byte[] x, byte[] y, byte[] c, byte[] m) {
        this.cLength = c.length;
        this.x = x;
        this.y = y;
        this.m = m;
        System.arraycopy(c, 0, this.c, 0, c.length);
    }

    public byte[] getX() {
        return this.x;
    }

    public byte[] getY() {
        return this.y;
    }

    public byte[] getC() {
        return this.c;
    }

    public byte[] getM() {
        return this.m;
    }

    public int getCLength() {
        return this.cLength;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buf.append(nl);
        buf.append("cLength: ").append(this.cLength).append(nl);
        buf.append("      X: ").append(new BigInteger(1, this.x).toString(16)).append(nl);
        buf.append("      Y: ").append(new BigInteger(1, this.y).toString(16)).append(nl);
        buf.append("      C: ").append(new BigInteger(1, this.c).toString(16)).append(nl);
        buf.append("      M: ").append(new BigInteger(1, this.m).toString(16)).append(nl);
        return buf.toString();
    }

    public void decode(byte[] cipher) {
        this.cLength = Bytes.bytes2int(cipher);
        int pos = 4;
        System.arraycopy(cipher, pos, this.x, 0, 32);
        System.arraycopy(cipher, pos += this.x.length, this.y, 0, 32);
        System.arraycopy(cipher, pos += this.y.length, this.c, 0, 136);
        System.arraycopy(cipher, pos += this.c.length, this.m, 0, 32);
    }

    public byte[] encode() {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            buf.write(Bytes.int2bytes(this.cLength));
            buf.write(this.x);
            buf.write(this.y);
            buf.write(this.c);
            buf.write(this.m);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buf.toByteArray();
    }

    public int size() {
        return 236;
    }
}

