/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.device.bean;

import com.sansec.device.bean.inf.IStructure;
import com.sansec.util.Bytes;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;

public class SM2refPrivateKey
implements IStructure {
    private int bits;
    private byte[] D = new byte[32];

    public SM2refPrivateKey() {
    }

    public SM2refPrivateKey(byte[] D) {
        this.bits = 256;
        this.D = D;
    }

    public int getBits() {
        return this.bits;
    }

    public byte[] getD() {
        return this.D;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buf.append("bits: ").append(this.bits).append(nl);
        buf.append("   D: ").append(new BigInteger(1, this.D).toString(16)).append(nl);
        return buf.toString();
    }

    public void decode(byte[] privateKey) {
        this.bits = Bytes.bytes2int(privateKey);
        int pos = 4;
        System.arraycopy(privateKey, pos, this.D, 0, 32);
    }

    public byte[] encode() {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            buf.write(Bytes.int2bytes(this.bits));
            buf.write(this.D);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buf.toByteArray();
    }

    public int size() {
        return 36;
    }

    public static int sizeof() {
        return 36;
    }
}

