/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.device.bean;

import com.sansec.device.bean.inf.IStructure;
import com.sansec.util.Bytes;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;

public class SM2refPublicKey
implements IStructure {
    private int bits;
    private byte[] x = new byte[32];
    private byte[] y = new byte[32];

    public int getBits() {
        return this.bits;
    }

    public byte[] getX() {
        return this.x;
    }

    public byte[] getY() {
        return this.y;
    }

    public SM2refPublicKey() {
    }

    public SM2refPublicKey(byte[] x, byte[] y) {
        this.bits = 256;
        this.x = x;
        this.y = y;
    }

    public void decode(byte[] publicKey) {
        this.bits = Bytes.bytes2int(publicKey);
        int pos = 4;
        System.arraycopy(publicKey, pos, this.x, 0, 32);
        System.arraycopy(publicKey, pos += this.x.length, this.y, 0, 32);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buf.append(nl);
        buf.append("bits: ").append(this.bits).append(nl);
        buf.append("   X: ").append(new BigInteger(1, this.x).toString(16)).append(nl);
        buf.append("   Y: ").append(new BigInteger(1, this.y).toString(16)).append(nl);
        return buf.toString();
    }

    public byte[] encode() {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            buf.write(Bytes.int2bytes(this.bits));
            buf.write(this.x);
            buf.write(this.y);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buf.toByteArray();
    }

    public int size() {
        return 68;
    }

    public static int sizeof() {
        return 68;
    }
}

