/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.device.bean;

import com.sansec.device.bean.inf.IStructure;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;

public class SM2refSignature
implements IStructure {
    private byte[] r = new byte[32];
    private byte[] s = new byte[32];

    public SM2refSignature() {
    }

    public SM2refSignature(byte[] r, byte[] s) {
        this.r = r;
        this.s = s;
    }

    public byte[] getR() {
        return this.r;
    }

    public byte[] getS() {
        return this.s;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buf.append(nl);
        buf.append("   R: ").append(new BigInteger(1, this.r).toString(16)).append(nl);
        buf.append("   S: ").append(new BigInteger(1, this.s).toString(16)).append(nl);
        return buf.toString();
    }

    public void decode(byte[] signature) {
        int pos = 0;
        System.arraycopy(signature, pos, this.r, 0, 32);
        pos += 4;
        System.arraycopy(signature, 32, this.s, 0, 32);
    }

    public byte[] encode() {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            buf.write(this.r);
            buf.write(this.s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buf.toByteArray();
    }

    public int size() {
        return 64;
    }
}

