/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.device.bean.config;

import com.sansec.device.bean.GlobalData;
import com.sansec.device.bean.config.ParseConfigException;
import com.sansec.device.socket.bean.HSMInfo;
import com.sansec.device.util.StringEx;
import com.sansec.util.JarUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class Profile {
    public static int MAX_HSM_COUNT = 10;
    public static int DEFAULT_CONN_PORT = 8008;
    public static String DEFAULT_CONN_PASSWORD = "11111111";
    static final String DEFAULT_INI_FILE = "/swsds.ini";
    static final String DEFAULT_LOG_DIR = "/SwxaLog";
    static final String DEFAULT_LOG_FILE = "/swsds.log";
    static final int DEFAULT_LOG_LEVEL = 1;
    static final int DEFAULT_CONNECT_TIMEOUT = 30;
    static final int DEFAULT_SERVICE_TIMEOUT = 30;
    static final int DEFAULT_CONNECT_POOLSIZE = 10;
    static final String HSMM = "HSMM";
    static final String CARD = "CARD";
    static final String SOFT = "SOFT";
    static final String DEFAULT_DEV_NAME = "HSMM";
    private Logger logger = null;
    private int connect = 0;
    private int service = 0;
    private int poolsize = 0;
    private int deviceType = 0;
    private List server = new ArrayList();
    private static Profile profile = null;

    public int getConnectTimeout() {
        return this.connect;
    }

    public int getServiceTimeout() {
        return this.service;
    }

    public int getConnectPoolSize() {
        return this.poolsize;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public List getServer() {
        return this.server;
    }

    public static String findCoinfigFilePath() {
        String path = ".//swsds.ini";
        if (new File(path).exists()) {
            return path;
        }
        JarUtil util = new JarUtil(JarUtil.class);
        path = String.valueOf(util.getJarPath()) + "/" + DEFAULT_INI_FILE;
        if (new File(path).exists()) {
            return path;
        }
        return null;
    }

    public static synchronized Profile getInstance() {
        if (profile == null) {
            profile = new Profile();
            String path = Profile.findCoinfigFilePath();
            if (path == null) {
                Profile.profile.deviceType = 1;
            } else {
                try {
                    profile.loadConfig(path);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return profile;
    }

    public void loadConfig(String filePath) throws ParseConfigException {
        String path = null;
        this.logger = GlobalData.logger;
        String value = this.getValue(filePath, "ErrorLog", "logfile");
        if (value == null) {
            File file = new File(DEFAULT_LOG_DIR);
            file.mkdir();
            FileHandler fh = null;
            try {
                fh = new FileHandler("/SwxaLog/swsds.log", true);
            }
            catch (SecurityException securityException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            fh.setFormatter(new SimpleFormatter());
            this.logger.addHandler(fh);
            this.logger.log(Level.INFO, "[ErrorLog] : logfile default");
            path = "/SwxaLog/swsds.log";
        } else {
            Handler fh = null;
            try {
                if (this.isFullPath(value)) {
                    fh = new FileHandler(path, true);
                } else {
                    File file = new File(String.valueOf(this.getParentPath(filePath)) + DEFAULT_LOG_DIR);
                    file.mkdir();
                    path = String.valueOf(this.getParentPath(filePath)) + "/SwxaLog/" + value;
                    fh = new FileHandler(path, true);
                }
            }
            catch (SecurityException file) {
            }
            catch (IOException file) {
                // empty catch block
            }
            fh.setFormatter(new SimpleFormatter());
            this.logger.addHandler(fh);
        }
        value = this.getValue(filePath, "ErrorLog", "level");
        if (value == null) {
            this.logger.setLevel(this.toLevel(1));
            this.logger.log(Level.INFO, "[ErrorLog] : level = " + this.toLevel(1) + "[default]");
        } else {
            try {
                this.logger.setLevel(this.toLevel(Integer.parseInt(value)));
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "[ErrorLog] : level isn't number");
                throw new ParseConfigException("[ErrorLog] : level isn't number");
            }
            this.logger.log(Level.INFO, "[ErrorLog] : level = " + this.toLevel(Integer.parseInt(value)));
        }
        value = this.getValue(filePath, "Device", "device");
        if (value == null) {
            value = "HSMM";
            this.logger.log(Level.INFO, "[Device] : device = HSMM[default]");
        }
        if ("card".equalsIgnoreCase(value)) {
            this.deviceType = 1;
        } else if ("hsmm".equalsIgnoreCase(value)) {
            this.deviceType = 2;
        } else if ("soft".equalsIgnoreCase(value)) {
            this.deviceType = 0;
        } else {
            this.logger.log(Level.SEVERE, "[Device] : device = " + value + " not support");
            throw new ParseConfigException("[Device] : device = " + value + " not support");
        }
        this.logger.log(Level.INFO, "[Device] : device = " + value);
        int i = 1;
        while (i <= MAX_HSM_COUNT) {
            String item = "HSM" + i;
            String ip = this.getValue(filePath, item, "ip");
            if (ip == null) {
                this.logger.log(Level.CONFIG, "[" + item + "] : ip not found");
            } else {
                int port;
                this.logger.info("[" + item + "] : ip = " + ip);
                String passwd = this.getValue(filePath, item, "passwd");
                if (passwd == null) {
                    passwd = DEFAULT_CONN_PASSWORD;
                    this.logger.info("[" + item + "] : passwd = " + passwd + "[default]");
                } else {
                    this.logger.info("[" + item + "] : passwd = " + passwd);
                }
                value = this.getValue(filePath, item, "port");
                if (value == null) {
                    port = DEFAULT_CONN_PORT;
                    this.logger.info("[" + item + "] : port = " + port + "[default]");
                } else {
                    port = -1;
                    try {
                        port = Integer.parseInt(value);
                    }
                    catch (Exception e) {
                        this.logger.log(Level.SEVERE, "[" + item + "] : port isn't number");
                        throw new ParseConfigException("[" + item + "] : port isn't number");
                    }
                    this.logger.info("[" + item + "] : port = " + port);
                }
                HSMInfo info = new HSMInfo(ip, port, passwd);
                this.server.add(info);
            }
            ++i;
        }
        value = this.getValue(filePath, "Timeout", "connect");
        if (value == null) {
            this.connect = 30;
            this.logger.info("[Timeout] : connect = " + this.connect + "[default]");
        } else {
            try {
                this.connect = Integer.parseInt(value);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "[Timeout] : connect isn't number");
                throw new ParseConfigException("[Timeout] : connect isn't number");
            }
            this.logger.info("[Timeout] : connect = " + this.connect);
        }
        value = this.getValue(filePath, "Timeout", "service");
        if (value == null) {
            this.service = 30;
            this.logger.info("[Timeout] : service = " + this.service + "[default]");
        } else {
            try {
                this.service = Integer.parseInt(value);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "[Timeout] : service isn't number");
                throw new ParseConfigException("[Timeout] : service isn't number");
            }
            this.logger.info("[Timeout] : service = " + this.service);
        }
        value = this.getValue(filePath, "ConnectionPool", "poolsize");
        if (value == null) {
            this.poolsize = 10;
            this.logger.info("[ConnectionPool] : poolsize = " + this.poolsize + "[default]");
        } else {
            try {
                this.poolsize = Integer.parseInt(value);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "[ConnectionPool] : poolsize isn't number");
                throw new ParseConfigException("[ConnectionPool] : poolsize isn't number");
            }
            this.logger.info("[ConnectionPool] : poolsize = " + this.poolsize);
        }
    }

    private String getValue(String filePath, String item, String key) {
        String str = null;
        item = "[" + item + "]";
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));
            StringEx strex = null;
            boolean findItem = false;
            while ((line = br.readLine()) != null) {
                strex = new StringEx(line);
                if (line.charAt(0) == '#') continue;
                line = line.toLowerCase();
                if (strex.contains(item.toLowerCase())) {
                    findItem = true;
                    continue;
                }
                if (findItem && strex.contains(key.toLowerCase())) {
                    str = line.substring(line.indexOf("=") + 1);
                    str = str.trim();
                    break;
                }
                if (findItem && strex.contains("[")) break;
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        return str;
    }

    private String getParentPath(String filePath) {
        File f = new File(filePath);
        return f.getParent();
    }

    private boolean isFullPath(String filePath) {
        StringEx path = new StringEx(filePath);
        if (path.startsWith("/")) {
            return true;
        }
        return path.contains(":\\") && path.substring(1).startsWith(":\\");
    }

    private Level toLevel(int n) {
        Level level = null;
        switch (n) {
            case 0: {
                level = Level.OFF;
                break;
            }
            case 1: {
                level = Level.SEVERE;
                break;
            }
            case 2: {
                level = Level.WARNING;
                break;
            }
            case 3: {
                level = Level.INFO;
                break;
            }
            case 4: {
                level = Level.CONFIG;
                break;
            }
            case 5: {
                level = Level.FINE;
                break;
            }
            case 6: {
                level = Level.FINER;
                break;
            }
            case 7: {
                level = Level.FINEST;
                break;
            }
            case 8: {
                level = Level.ALL;
                break;
            }
        }
        return level;
    }

    public static void main(String[] args) throws ParseConfigException {
        Profile profile = new Profile();
        profile.loadConfig("./crypto.ini");
        System.out.println(true);
    }
}

