/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.device.crypto;

import com.sansec.device.bean.DeviceInfo;
import com.sansec.device.bean.RSArefKeyPair;
import com.sansec.device.bean.SM2refCipher;
import com.sansec.device.bean.SM2refKeyPair;
import com.sansec.device.bean.SM2refPrivateKey;
import com.sansec.device.bean.SM2refPublicKey;
import com.sansec.device.bean.SM2refSignature;
import com.sansec.device.bean.inf.IRSArefPrivateKey;
import com.sansec.device.bean.inf.IRSArefPublicKey;
import com.sansec.device.crypto.CryptoException;

public interface ISDSCrypto {
    public static final int DES3_ECB = 2049;
    public static final int DES3_CBC = 2050;
    public static final int AES_ECB = 1025;
    public static final int AES_CBC = 1026;
    public static final int SM1_ECB = 257;
    public static final int SM1_CBC = 258;
    public static final int SM4_ECB = 8193;
    public static final int SM4_CBC = 8194;
    public static final int SSF33_ECB = 513;
    public static final int SSF33_CBC = 514;
    public static final int KEY_TYPE_SIGN = 2;
    public static final int KEY_TYPE_ENC = 1;
    public static final int SIGN_RSA = 65536;
    public static final int SIGN_SM2 = 131072;

    public byte[] generateRandom(int var1) throws CryptoException;

    public DeviceInfo getDeviceInfo() throws CryptoException;

    public IRSArefPublicKey getRSAPublicKey(int var1, int var2) throws CryptoException;

    public RSArefKeyPair generateRSAKeyPair(int var1) throws CryptoException;

    public byte[] rsaPrivateKeyOperation(int var1, int var2, byte[] var3) throws CryptoException;

    public byte[] rsaPublicKeyOperation(int var1, int var2, byte[] var3) throws CryptoException;

    public byte[] rsaPublicKeyOperation(IRSArefPublicKey var1, byte[] var2) throws CryptoException;

    public byte[] rsaPrivateKeyOperation(IRSArefPrivateKey var1, byte[] var2) throws CryptoException;

    public SM2refPublicKey getSM2PublicKey(int var1, int var2) throws CryptoException;

    public SM2refKeyPair generateSM2KeyPair(int var1) throws CryptoException;

    public SM2refCipher sm2Encrypt(int var1, int var2, byte[] var3) throws CryptoException;

    public byte[] sm2Decrypt(int var1, int var2, SM2refCipher var3) throws CryptoException;

    public SM2refCipher sm2Encrypt(SM2refPublicKey var1, byte[] var2) throws CryptoException;

    public byte[] sm2Decrypt(SM2refPrivateKey var1, SM2refCipher var2) throws CryptoException;

    public SM2refSignature sm2Sign(int var1, byte[] var2) throws CryptoException;

    public SM2refSignature sm2Sign(SM2refPrivateKey var1, byte[] var2) throws CryptoException;

    public boolean sm2Verify(int var1, byte[] var2, SM2refSignature var3) throws CryptoException;

    public boolean sm2Verify(SM2refPublicKey var1, byte[] var2, SM2refSignature var3) throws CryptoException;

    public byte[] encrypt(int var1, byte[] var2, byte[] var3, byte[] var4) throws CryptoException;

    public byte[] decrypt(int var1, byte[] var2, byte[] var3, byte[] var4) throws CryptoException;

    public byte[] encrypt(int var1, int var2, byte[] var3, byte[] var4) throws CryptoException;

    public byte[] decrypt(int var1, int var2, byte[] var3, byte[] var4) throws CryptoException;
}

